import { addca3a7e9c7649ae } from "../internal/a69125a36514bd909/addca3a7e9c7649ae";
import { a0a3f6243a838daa9 } from "../internal/a69125a36514bd909/a0a3f6243a838daa9";
import { abbd1162d94a8dc3a } from "../internal/a69125a36514bd909/abbd1162d94a8dc3a";
import { a0a33eb557755ca01 } from "../internal/a8a18cf9e949aa517/a0a33eb557755ca01";
/* eslint-disable @typescript-eslint/no-explicit-any */
export class DisplayBuilder extends addca3a7e9c7649ae {
    _parameters;
    constructor() {
        super();
        this._parameters = new Map([
            ["category", "Display"],
            ["contents", new Array()],
        ]);
    }
    styleInternationalCharacter(type) {
        this._addAction(async () => {
            const contents = this._parameters.get("contents");
            contents.push(new Map([
                ["method", "Style.InternationalCharacter"],
                [
                    "parameter",
                    new Map([
                        [
                            "type",
                            a0a3f6243a838daa9.convertDisplayInternationalCharacterType(type),
                        ],
                    ]),
                ],
            ]));
        });
        return this;
    }
    styleCharacterEncoding(type) {
        this._addAction(async () => {
            const contents = this._parameters.get("contents");
            contents.push(new Map([
                ["method", "Style.CharacterEncoding"],
                [
                    "parameter",
                    new Map([
                        [
                            "type",
                            a0a3f6243a838daa9.convertDisplayCharacterEncodingType(type),
                        ],
                    ]),
                ],
            ]));
        });
        return this;
    }
    styleCursorPositionTo(parameter) {
        this._addAction(async () => {
            const contents = this._parameters.get("contents");
            contents.push(new Map([
                ["method", "Style.CursorPositionTo"],
                [
                    "parameter",
                    new Map([
                        ["x", Math.floor(parameter.x)],
                        ["y", Math.floor(parameter.y)],
                    ]),
                ],
            ]));
        });
        return this;
    }
    actionClearLine() {
        this._addAction(async () => {
            const contents = this._parameters.get("contents");
            contents.push(new Map([
                ["method", "Action.Clear.Line"],
                ["parameter", new Map()],
            ]));
        });
        return this;
    }
    actionClearAll() {
        this._addAction(async () => {
            const contents = this._parameters.get("contents");
            contents.push(new Map([
                ["method", "Action.Clear.All"],
                ["parameter", new Map()],
            ]));
        });
        return this;
    }
    actionSetBackLightState(on) {
        this._addAction(async () => {
            const contents = this._parameters.get("contents");
            contents.push(new Map([
                ["method", "Action.Set.BackLightState"],
                ["parameter", new Map([["on", on]])],
            ]));
        });
        return this;
    }
    actionSetCursorState(state) {
        this._addAction(async () => {
            const contents = this._parameters.get("contents");
            contents.push(new Map([
                ["method", "Action.Set.CursorState"],
                [
                    "parameter",
                    new Map([
                        ["value", a0a3f6243a838daa9.convertCursorState(state)],
                    ]),
                ],
            ]));
        });
        return this;
    }
    actionSetContrast(value) {
        this._addAction(async () => {
            const contents = this._parameters.get("contents");
            contents.push(new Map([
                ["method", "Action.Set.Contrast"],
                [
                    "parameter",
                    new Map([
                        ["value", a0a3f6243a838daa9.convertContrast(value)],
                    ]),
                ],
            ]));
        });
        return this;
    }
    actionShowText(content) {
        this._addAction(async () => {
            const contents = this._parameters.get("contents");
            contents.push(new Map([
                ["method", "Action.Show.Text"],
                [
                    "parameter",
                    new Map([
                        [
                            "content",
                            abbd1162d94a8dc3a.convertString(content),
                        ],
                    ]),
                ],
            ]));
        });
        return this;
    }
    actionShowImage(parameter) {
        //固定値
        this._addAction(async () => {
            const width = 160; //固定値
            const height = 40; //固定値
            const adjustedImageInfo = await a0a33eb557755ca01.createAdjustedImageInfo(parameter.source, width, height, parameter.effectDiffusion, parameter.threshold);
            const contents = this._parameters.get("contents");
            contents.push(new Map([
                ["method", "Action.Show.Image"],
                ["parameter", adjustedImageInfo],
            ]));
        });
        return this;
    }
}
