import { BrowserRouter, Routes, Route } from "react-router-dom";
import Discovery from "./Discovery";
import Printing from "./Printing";
import Printing_Template from "./Printing_Template";
import Status from "./Status";

import "./App.css";

function App() {
  return (
    <div style={{ width: "fit-content", margin: "0 auto" }}>
      <a href="/">
        <h1>StarXpand SDK for Web</h1>
      </a>
      <BrowserRouter>
        <Routes>
          <Route path="/" element={<Home />} />
          <Route path="/discovery" element={<Discovery />} />
          <Route path="/printing_template" element={<Printing_Template />} />
          <Route path="/printing" element={<Printing />} />
          <Route path="/status" element={<Status />} />
        </Routes>
      </BrowserRouter>
    </div>
  );
}

function Home() {
  return (
    <div className="App">
      <ul>
        <a href="/discovery">Discovery</a>
        <br />
        <a href="/printing">Printing</a>
        <br />
        <a href="/printing_template">Printing_Template</a>
        <br />
        <a href="/status">Status</a>
        <br />
      </ul>
    </div>
  );
}

export default App;
