import { StarXpandCommand } from "star-io10-web";

export class ReceiptSample04_FoodDelivery2_Template {
  static async createTemplate(): Promise<string> {
    let builder = new StarXpandCommand.StarXpandCommandBuilder();

    builder.addDocument(
      new StarXpandCommand.DocumentBuilder()
        .settingPrintableArea(72.0)
        .addPrinter(
          new StarXpandCommand.PrinterBuilder()
            .add(
              new StarXpandCommand.PrinterBuilder()
                .styleBold(true)
                .styleMagnification(
                  new StarXpandCommand.MagnificationParameter(2, 2),
                )
                .actionPrintText("${store_name}\n")
                .styleInvert(true)
                .actionPrintText(
                  "${order_number}",
                  new StarXpandCommand.Printer.TextParameter().setWidth(
                    7,
                    new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                      StarXpandCommand.Printer.TextAlignment.Left,
                    ),
                  ),
                )
                .styleBold(false)
                .actionPrintText(
                  "${customer_name}\n",
                  new StarXpandCommand.Printer.TextParameter().setWidth(
                    17,
                    new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                      StarXpandCommand.Printer.TextAlignment.Right,
                    ),
                  ),
                ),
            )
            .actionPrintText("Placed at ${placed_at}\n")
            .styleBold(true)
            .actionPrintText("Due at ${due_at}")
            .styleBold(false)
            .actionPrintRuledLine(
              new StarXpandCommand.Printer.RuledLineParameter(
                72.0,
              ).setThickness(0.1),
            )
            .add(
              new StarXpandCommand.PrinterBuilder()
                .actionFeed(4.0)
                .styleAlignment(StarXpandCommand.Printer.Alignment.Center)
                .styleMagnification(
                  new StarXpandCommand.MagnificationParameter(2, 2),
                )
                .actionPrintText("${order_types}\n")
                .actionFeed(2.0),
            )
            .actionPrintRuledLine(
              new StarXpandCommand.Printer.RuledLineParameter(
                72.0,
              ).setThickness(0.1),
            )
            .actionPrintText("Disposable items:${disposable_items}\n")
            .actionPrintRuledLine(
              new StarXpandCommand.Printer.RuledLineParameter(
                72.0,
              ).setThickness(0.1),
            )
            .add(
              new StarXpandCommand.PrinterBuilder(
                new StarXpandCommand.Printer.PrinterParameter().setTemplateExtension(
                  new StarXpandCommand.TemplateExtensionParameter().setEnableArrayFieldData(
                    true,
                  ),
                ),
              )
                .styleBold(true)
                .actionPrintText(
                  "${item_list.quantity} x ${item_list.name}",
                  new StarXpandCommand.Printer.TextParameter().setWidth(39),
                )
                .actionPrintText(" ")
                .styleBold(false)
                .actionPrintText(
                  "$${item_list.price%.2f}\n",
                  new StarXpandCommand.Printer.TextParameter().setWidth(
                    8,
                    new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                      StarXpandCommand.Printer.TextAlignment.Right,
                    ),
                  ),
                )
                .actionPrintText(
                  "${item_list.detail1}" +
                    "${item_list.detail2}" +
                    "${item_list.detail3}" +
                    "${item_list.detail4}",
                )
                .actionFeed(1.0),
            )
            .actionPrintRuledLine(
              new StarXpandCommand.Printer.RuledLineParameter(
                72.0,
              ).setThickness(0.1),
            )
            .actionPrintText("Subtotal")
            .actionPrintText(
              "$${subtotal%.2f}\n",
              new StarXpandCommand.Printer.TextParameter().setWidth(
                40,
                new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                  StarXpandCommand.Printer.TextAlignment.Right,
                ),
              ),
            )
            .styleBold(true)
            .actionPrintText("Amount paid")
            .actionPrintText(
              "$${total%.2f}\n",
              new StarXpandCommand.Printer.TextParameter().setWidth(
                37,
                new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                  StarXpandCommand.Printer.TextAlignment.Right,
                ),
              ),
            )
            .styleBold(false)
            .actionPrintRuledLine(
              new StarXpandCommand.Printer.RuledLineParameter(
                72.0,
              ).setThickness(0.1),
            )
            .styleAlignment(StarXpandCommand.Printer.Alignment.Center)
            .actionPrintText("${note}")
            .actionCut(StarXpandCommand.Printer.CutType.Partial),
        ),
    );
    return await builder.getCommands();
  }

  static async getFieldData(): Promise<string> {
    return Promise.resolve(
      `{
    "store_name" : "Star Delivery",
    "order_number" : "4053D",
    "customer_name" : "John Smith",
    "placed_at" : "30 June 2023 6:46 PM",
    "due_at" : "30 June 2023 7:16 PM",
    "order_types" : "DELIVERY",
    "disposable_items" : "No",
    "item_list" : [
        {
            "name" : "Nugget Kid",
            "quantity" : 1,
            "price" : 15.0
        },
        {
            "name" : "Nugget Kid",
            "quantity" : 1,
            "price" : 15.0
        },
        {
            "name" : "Salmon Avocado Mini Roll",
            "quantity" : 2,
            "price" : 13.60
        },
        {
            "name" : "Salmon Teriyaki",
            "quantity" : 1,
            "price" : 38.0,
            "detail1" : "  DIETARY SUBSTITUTION\\n",
            "detail2" : "    1x Gluten Free                            --\\n",
            "detail3" : "  CHOICE OF ADD ONS\\n",
            "detail4" : "    1x Rice                                $4.00\\n"
        },
        {
            "name" : "Wagyu Beef BBQ",
            "quantity" : 1,
            "price" : 44.0,
            "detail1" : "  CHOICE OF ADD ONS\\n",
            "detail2" : "    1x Rice                                $4.00\\n"
        }
    ],
    "subtotal" : 133.6,
    "total" : 133.6,
    "note" : "Thank you for ordering from StarMicronics"
}`,
    );
  }
}
