import { StarXpandCommand } from "star-io10-web";

export class ReceiptSample03_FoodDelivery1_Template {
  static async createTemplate(): Promise<string> {
    let builder = new StarXpandCommand.StarXpandCommandBuilder();

    builder.addDocument(
      new StarXpandCommand.DocumentBuilder()
        .settingPrintableArea(72.0)
        .addPrinter(
          new StarXpandCommand.PrinterBuilder()
            .styleAlignment(StarXpandCommand.Printer.Alignment.Center)
            .styleBold(true)
            .styleMagnification(
              new StarXpandCommand.MagnificationParameter(2, 2),
            )
            .actionPrintText(
              "${store_name}\n",
              new StarXpandCommand.Printer.TextParameter().setWidth(
                24,
                new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                  StarXpandCommand.Printer.TextAlignment.Center,
                ),
              ),
            )
            .styleAlignment(StarXpandCommand.Printer.Alignment.Left)
            .styleBold(false)
            .actionPrintText("------------------------")
            .add(
              new StarXpandCommand.PrinterBuilder()
                .styleMagnification(
                  new StarXpandCommand.MagnificationParameter(1, 1),
                )
                .actionPrintText("Customer Name\n"),
            )
            .styleBold(true)
            .actionPrintText("${customer_name}\n")
            .styleBold(false)
            .add(
              new StarXpandCommand.PrinterBuilder()
                .styleMagnification(
                  new StarXpandCommand.MagnificationParameter(1, 1),
                )
                .actionPrintText("Delivery\n"),
            )
            .actionPrintText("${staff_name}\n")
            .add(
              new StarXpandCommand.PrinterBuilder()
                .styleMagnification(
                  new StarXpandCommand.MagnificationParameter(1, 1),
                )
                .actionPrintText("Delivery Pickup Time\n"),
            )
            .actionPrintText("${pickup_time}\n")
            .add(
              new StarXpandCommand.PrinterBuilder()
                .styleMagnification(
                  new StarXpandCommand.MagnificationParameter(1, 1),
                )
                .actionPrintText("Order Number\n"),
            )
            .actionPrintText("${order_number}\n")
            .add(
              new StarXpandCommand.PrinterBuilder()
                .styleMagnification(
                  new StarXpandCommand.MagnificationParameter(1, 1),
                )
                .actionPrintText("Total Items\n"),
            )
            .actionPrintText("${total_items} items\n")
            .actionPrintText("------------------------")
            .add(
              new StarXpandCommand.PrinterBuilder(
                new StarXpandCommand.Printer.PrinterParameter().setTemplateExtension(
                  new StarXpandCommand.TemplateExtensionParameter().setEnableArrayFieldData(
                    true,
                  ),
                ),
              )
                .actionPrintText(
                  "${item_list.quantity}x${item_list.name}",
                  new StarXpandCommand.Printer.TextParameter().setWidth(18),
                )
                .actionPrintText(" ")
                .actionPrintText(
                  "$${item_list.price%.2f}\n",
                  new StarXpandCommand.Printer.TextParameter().setWidth(
                    5,
                    new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                      StarXpandCommand.Printer.TextAlignment.Right,
                    ),
                  ),
                )
                .actionPrintText("${item_list.detail}")
                .actionPrintText("------------------------\n"),
            )
            .actionPrintText("${total_items} totalitems\n")
            .actionPrintText("Subtotal")
            .actionPrintText(
              "$${subtotal%.2f}\n",
              new StarXpandCommand.Printer.TextParameter().setWidth(
                16,
                new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                  StarXpandCommand.Printer.TextAlignment.Right,
                ),
              ),
            )
            .styleBold(true)
            .actionPrintText("Total")
            .actionPrintText(
              "$${total%.2f}\n",
              new StarXpandCommand.Printer.TextParameter().setWidth(
                19,
                new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                  StarXpandCommand.Printer.TextAlignment.Right,
                ),
              ),
            )
            .actionCut(StarXpandCommand.Printer.CutType.Partial),
        ),
    );
    return await builder.getCommands();
  }

  static async getFieldData(): Promise<string> {
    return Promise.resolve(
      `{
    "store_name" : "Star Delivery",
    "customer_name" : "John Smith",
    "staff_name" : "Jane S",
    "pickup_time" : "Sun, Sep 17, 1:22 AM",
    "order_number" : "#ef9458a8",
    "total_items" : 5,
    "item_list" : [
        {
            "name" : "Star Water",
            "quantity" : 1,
            "price" : 2.49,
            "detail" : "Enhanced Water(20 oz)\\n"
        },
        {
            "name" : " Star Enhanced",
            "quantity" : 2,
            "price" : 5.98,
            "detail" : "Purified Water(1L)\\n"
        },
        {
            "name" : " Star Blue",
            "quantity" : 2,
            "price" : 5.98,
            "detail" : "Thirst Quencher(28 oz)\\n"
        }
    ],
    "subtotal" : 14.45,
    "total" : 14.45
}`,
    );
  }
}
