import { StarXpandCommand } from "star-io10-web";

export class LabelSample20_For203dpiAnd300dpi_VisitorLabel_Template {
  static async createTemplate(): Promise<string> {
    let builder = new StarXpandCommand.StarXpandCommandBuilder();

    builder.addDocument(
      new StarXpandCommand.DocumentBuilder()
        .settingPrintableArea(48.0)
        .addPrinter(
          new StarXpandCommand.PrinterBuilder()
            // By setting the base print size of text to x1.5 for 300dpi,
            // you can print text at the same size as 203dpi.
            //.styleBaseMagnification(new BaseMagnificationParameter().setText(BaseMagnification.X1_5))
            .addPageMode(
              new StarXpandCommand.Printer.PageModeAreaParameter(48.0, 90.0),
              new StarXpandCommand.PageModeBuilder()
                .stylePrintDirection(
                  StarXpandCommand.Printer.PageModePrintDirection.TopToBottom,
                )
                .actionPrintImage(
                  new StarXpandCommand.Printer.PageModeImageParameter(
                    "logo_01.png",
                    7.0,
                    4.0,
                    140,
                  ),
                )
                .actionPrintImage(
                  new StarXpandCommand.Printer.PageModeImageParameter(
                    "visitor_label_user_profile_picture.png",
                    5.0,
                    14.0,
                    160,
                  ),
                )
                .actionPrintRuledLine(
                  new StarXpandCommand.Printer.PageModeRuledLineParameter(
                    4.0,
                    12.0,
                    75.0,
                    12.0,
                  ),
                )
                .addPageMode(
                  new StarXpandCommand.Printer.PageModeAreaParameter(48.0, 52.0)
                    .setX(0.0)
                    .setY(28.0),
                  new StarXpandCommand.PageModeBuilder()
                    .styleBold(true)
                    .styleHorizontalPositionTo(0.0)
                    .styleVerticalPositionTo(8.0)
                    .styleMagnification(
                      new StarXpandCommand.MagnificationParameter(3, 3),
                    )
                    .actionPrintText("VISITOR\n")
                    .styleMagnification(
                      new StarXpandCommand.MagnificationParameter(2, 2),
                    )
                    .styleVerticalPositionBy(5.0)
                    .actionPrintText(
                      "${name}\n",
                      new StarXpandCommand.Printer.TextParameter().setWidth(17),
                    )
                    .styleMagnification(
                      new StarXpandCommand.MagnificationParameter(1, 1),
                    )
                    .styleVerticalPositionBy(1.0)
                    .actionPrintText(
                      "${company_name}\n",
                      new StarXpandCommand.Printer.TextParameter().setWidth(34),
                    )
                    .styleBold(false)
                    .styleVerticalPositionBy(1.0)
                    .actionPrintText("Visiting:")
                    .styleBold(true)
                    .actionPrintText(
                      "${visiting}\n",
                      new StarXpandCommand.Printer.TextParameter().setWidth(25),
                    )
                    .styleBold(false)
                    .styleVerticalPositionBy(1.0)
                    .actionPrintText(
                      "${datetime}\n",
                      new StarXpandCommand.Printer.TextParameter().setWidth(34),
                    )
                    .styleHorizontalPositionTo(5.0)
                    .styleVerticalPositionBy(3.0)
                    .actionPrintBarcode(
                      new StarXpandCommand.Printer.BarcodeParameter(
                        "${barcode}",
                        StarXpandCommand.Printer.BarcodeSymbology.Code128,
                      )
                        .setHeight(5.0)
                        .setPrintHri(true),
                    ),
                )
                .addPageMode(
                  new StarXpandCommand.Printer.PageModeAreaParameter(28.0, 10.0)
                    .setX(10.0)
                    .setY(80.0),
                  new StarXpandCommand.PageModeBuilder()
                    .styleHorizontalPositionTo(0.0)
                    .styleVerticalPositionTo(0.0)
                    .stylePrintDirection(
                      StarXpandCommand.Printer.PageModePrintDirection
                        .LeftToRight,
                    )
                    .styleBold(true)
                    .styleLineSpace(0.0)
                    .actionPrintText(
                      "FOLD\n",
                      new StarXpandCommand.Printer.TextParameter().setWidth(
                        18,
                        new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                          StarXpandCommand.Printer.TextAlignment.Center,
                        ),
                      ),
                    )
                    .actionPrintText(
                      "UNDER\n",
                      new StarXpandCommand.Printer.TextParameter().setWidth(
                        18,
                        new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                          StarXpandCommand.Printer.TextAlignment.Center,
                        ),
                      ),
                    )
                    .actionPrintText(
                      "▼   ▼\n",
                      new StarXpandCommand.Printer.TextParameter().setWidth(
                        18,
                        new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                          StarXpandCommand.Printer.TextAlignment.Center,
                        ),
                      ),
                    ),
                ),
            )
            .actionCut(StarXpandCommand.Printer.CutType.Partial),
        ),
    );

    return builder.getCommands();
  }

  static async getFieldData(): Promise<string> {
    return Promise.resolve(
      `{
    "name" : "John Smith",
    "company_name" : "Star Micronics",
    "visiting" : "Jane Smith",
    "datetime" : "4/14/2014 1:09 PM",
    "barcode" : "VPS10298"
}`,
    );
  }
}
