import { StarXpandCommand } from "star-io10-web";

export class LabelSample19_For203dpiAnd300dpi_PrescriptionLabel_Template {
  static async createTemplate(): Promise<string> {
    let builder = new StarXpandCommand.StarXpandCommandBuilder();

    builder.addDocument(
      new StarXpandCommand.DocumentBuilder()
        // Change the printable area setting for this layout according to the printer resolution.
        // 72.0 for 203dpi, 48.7 for 300dpi
        .settingPrintableArea(72.0)
        //.settingPrintableArea(48.7)
        .addPrinter(
          new StarXpandCommand.PrinterBuilder()
            .actionPrintText("${contents}\n")
            .add(
              new StarXpandCommand.PrinterBuilder()
                .styleMagnification(
                  new StarXpandCommand.MagnificationParameter(1, 2),
                )
                .actionPrintText("Take ")
                .styleBold(true)
                .actionPrintText("${number_of_tablet}")
                .styleBold(false)
                .actionPrintText(" tablet ")
                .styleBold(true)
                .actionPrintText("${number_of_times}")
                .styleBold(false)
                .actionPrintText(" times ${dose_interval}"),
            )
            .actionFeed(7.0)
            .styleBold(true)
            .actionPrintText("Warning ")
            .styleBold(false)
            .actionPrintText(
              "${warning1}\n" + "${warning2}\n" + "${warning3}\n",
            )
            .styleBold(true)
            .actionPrintText("${name}")
            .styleBold(false)
            .styleHorizontalPositionTo(0.0)
            .actionPrintText(
              "${date}\n",
              new StarXpandCommand.Printer.TextParameter().setWidth(
                42,
                new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                  StarXpandCommand.Printer.TextAlignment.Right,
                ),
              ),
            )
            .actionPrintRuledLine(
              new StarXpandCommand.Printer.RuledLineParameter(
                72.0,
              ).setThickness(0.4),
            )
            .styleLineSpace(3.0)
            .actionPrintText(
              "For Advice ${for_advice}\n" +
                "Keep out of sight and reach of children\n" +
                "${address}\n",
            )
            .actionCut(StarXpandCommand.Printer.CutType.Partial),
        ),
    );
    return await builder.getCommands();
  }

  static async getFieldData(): Promise<string> {
    return Promise.resolve(
      `{
    "contents" : "28 Medicine Name 200mg tablets",
    "number_of_tablet" : "ONE",
    "number_of_times" : "THREE",
    "dose_interval" : "a day",
    "warning1" : "avoid alcoholic drink",
    "warning2" : "Take with or after food",
    "warning3" : "Take regularly and complete the course",
    "name" : "John Smith",
    "date" : "01 Jan 2018",
    "for_advice" : "012 345 6789",
    "address" : "123 HIGH STREET LONDON, SW1A 1AA"
}`,
    );
  }
}
