import { StarXpandCommand } from "star-io10-web";

export class LabelSample15_For203dpiAnd300dpi_FoodDeliveryThaiLabel_Template {
  static async createTemplate(): Promise<string> {
    let builder = new StarXpandCommand.StarXpandCommandBuilder();

    builder.addDocument(
      new StarXpandCommand.DocumentBuilder()
        // Change the printable area setting for this layout according to the printer resolution.
        // 48.0 for 203dpi, 48.7 for 300dpi
        .settingPrintableArea(48.0)
        //.settingPrintableArea(48.7)
        .addPrinter(
          new StarXpandCommand.PrinterBuilder()
            // By setting the base print size of text to x1.5 for 300dpi,
            // you can print text at the same size as 203dpi.
            //.styleBaseMagnification(new BaseMagnificationParameter().setText(BaseMagnification.X1_5))
            .styleInternationalCharacter(
              StarXpandCommand.Printer.InternationalCharacterType.Usa,
            )
            .styleCharacterSpace(0.0)
            .styleAlignment(StarXpandCommand.Printer.Alignment.Center)
            .styleBold(true)
            .actionPrintText("สลิปการสั่งซื้อ\n")
            .styleBold(false)
            .actionPrintText("${store_name}  \n" + "${address} \n")
            .add(
              new StarXpandCommand.PrinterBuilder()
                .styleBold(true)
                .actionPrintText("#${number%04u}\n"),
            )
            .actionPrintText(
              "วันที่:${date}  เวลา:${time}\n" +
                "--------------------------------\n",
            )
            .styleAlignment(StarXpandCommand.Printer.Alignment.Left)
            .actionPrintText("ลูกค้า: ")
            .styleBold(true)
            .actionPrintText("${customer_name} \n")
            .styleBold(false)
            .actionPrintText(
              "ชำระเงินแล้ว \n" +
                "เวลาที่รับออเดอร์:${order_time}\n" +
                "--------------------------------\n" +
                "\n",
            )
            .add(
              new StarXpandCommand.PrinterBuilder(
                new StarXpandCommand.Printer.PrinterParameter().setTemplateExtension(
                  new StarXpandCommand.TemplateExtensionParameter().setEnableArrayFieldData(
                    true,
                  ),
                ),
              )
                .styleHorizontalTabPositions([3, 18, 23])
                .actionPrintText(
                  "${item_list.number_of_items}X\t${item_list.name}\t",
                )
                .actionPrintText(
                  "${item_list.price}",
                  new StarXpandCommand.Printer.TextParameter().setWidth(
                    4,
                    new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                      StarXpandCommand.Printer.TextAlignment.Right,
                    ),
                  ),
                )
                .actionPrintText("\tบาท\n"),
            )
            .actionPrintText("--------------------------------\n")
            .add(
              new StarXpandCommand.PrinterBuilder()
                .styleAlignment(StarXpandCommand.Printer.Alignment.Center)
                .actionPrintText("${note}\n"),
            )
            .actionPrintText("--------------------------------\n")
            .add(
              new StarXpandCommand.PrinterBuilder()
                .styleHorizontalTabPositions([26])
                .actionPrintText("รวม\t")
                .styleBold(true)
                .actionPrintText("${sub_total}")
                .styleBold(true)
                .actionPrintText("บาท\n")
                .actionPrintText("ภาษีมูลค่าเพิ่ม\t")
                .actionPrintText("${tax}\n"),
            )
            .actionPrintText("--------------------------------\n")
            .add(
              new StarXpandCommand.PrinterBuilder()
                .styleAlignment(StarXpandCommand.Printer.Alignment.Left)
                .styleBold(true)
                .actionPrintText("รวมทั้งหมด\n")
                .styleAlignment(StarXpandCommand.Printer.Alignment.Right)
                .actionPrintText("${total} บาท\n"),
            )
            .actionPrintText(
              "--------------------------------\n" +
                "\n" +
                "Charge ${charge}\n" +
                "\n",
            )
            .styleAlignment(StarXpandCommand.Printer.Alignment.Center)
            .add(
              new StarXpandCommand.PrinterBuilder()
                .styleInvert(true)
                .actionPrintText("การขอใบกำกับภาษี\n"),
            )
            .actionPrintText(
              "นี่ไม่ใช่ใบเสร็จรับเงินอย่างเป็นทางการ\n" +
                "และไม่สามารถใช้ในการคืนภาษีได้\n" +
                "โปรดขอใบกำกับภาษีอย่างเป็นทางการจากผู้ขาย\n" +
                "\n",
            )
            .actionFeedLine(1)
            .actionPrintQRCode(
              new StarXpandCommand.Printer.QRCodeParameter("${store_url}")
                .setModel(StarXpandCommand.Printer.QRCodeModel.Model2)
                .setLevel(StarXpandCommand.Printer.QRCodeLevel.L)
                .setCellSize(8),
            )
            .actionCut(StarXpandCommand.Printer.CutType.Partial),
        ),
    );

    return await builder.getCommands();
  }

  static async getFieldData(): Promise<string> {
    return Promise.resolve(
      `{
    "store_name" : "ร้าน STAR EAT",
    "address" : "Bangkok , Thailand",
    "number" : 1,
    "date" : "ดด/วว/ปปปป",
    "time" : "HH:MM PM",
    "customer_name" : "Mr. Star Micronics",
    "order_time" : "HH:MM PM",
    "item_list" : [
        {
            "number_of_items" : 1,
            "name" : "ข้าวผัดปู",
            "price" : 59
        },
        {
            "number_of_items" : 1,
            "name" : "ต้มยำกุ้ง",
            "price" : 120
        },
        {
            "number_of_items" : 2,
            "name" : "ก๋วยเตี๋ยวหมูน้ำตก",
            "price" : 69
        }
    ],
    "note" : "**โปรดเตรียมช้อนส้อมให้ด้วย",
    "sub_total" : 248,
    "tax" : "-",
    "total" : 248,
    "charge" : "Visa XXXX-XXXX-XXXX-0123",
    "store_url" : "https://starmicronics.co.th/en/contact/"
}`,
    );
  }
}
