import { StarXpandCommand } from "star-io10-web";

export class LabelSample13_For203dpiAnd300dpi_FoodProductLabel_Template {
  static async createTemplate(): Promise<string> {
    let builder = new StarXpandCommand.StarXpandCommandBuilder();

    builder.addDocument(
      new StarXpandCommand.DocumentBuilder()
        // Change the printable area setting for this layout according to the printer resolution.
        // 72.0 for 203dpi, 48.7 for 300dpi
        .settingPrintableArea(72.0)
        //.settingPrintableArea(48.7)
        .addPrinter(
          new StarXpandCommand.PrinterBuilder()
            .styleAlignment(StarXpandCommand.Printer.Alignment.Center)
            .styleBold(true)
            .add(
              new StarXpandCommand.PrinterBuilder()
                .styleMagnification(
                  new StarXpandCommand.MagnificationParameter(2, 2),
                )
                .actionPrintText("${name}\n"),
            )
            .actionPrintText(
              "${message}\n" +
                "------------------------------------------------\n" +
                "MFG ${manufacturing_date}\n" +
                "------------------------------------------------\n" +
                "${note}\n",
            )
            .actionCut(StarXpandCommand.Printer.CutType.Partial),
        ),
    );

    return await builder.getCommands();
  }

  static async getFieldData(): Promise<string> {
    return Promise.resolve(
      `{
    "name" : "Star's Lunch Box -A-",
    "message" : "Use special sauce as you like",
    "manufacturing_date" : "2021/4/1",
    "note" : "Contains Wheat, Milk, and Soy.\\nMay Contains Sesame."
}`,
    );
  }
}
