import { StarXpandCommand } from "star-io10-web";

export class LabelSample11_For203dpiAnd300dpi_ShippingAddressLabel_Template {
  static async createTemplate(): Promise<string> {
    let builder = new StarXpandCommand.StarXpandCommandBuilder();

    builder.addDocument(
      new StarXpandCommand.DocumentBuilder()
        // Change the printable area setting for this layout according to the printer resolution.
        // 72.0 for 203dpi, 48.7 for 300dpi
        .settingPrintableArea(72.0)
        //.settingPrintableArea(48.7)
        .addPrinter(
          new StarXpandCommand.PrinterBuilder()
            .styleAlignment(StarXpandCommand.Printer.Alignment.Center)
            .styleMagnification(
              new StarXpandCommand.MagnificationParameter(2, 2),
            )
            .actionPrintText("${name}\n")
            .add(
              new StarXpandCommand.PrinterBuilder()
                .styleBold(true)
                .actionPrintText("${company}\n"),
            )
            .actionPrintText("${address}\n")
            .styleBold(true)
            .actionPrintText("${country}\n")
            .actionCut(StarXpandCommand.Printer.CutType.Partial),
        ),
    );

    return await builder.getCommands();
  }

  static async getFieldData(): Promise<string> {
    return Promise.resolve(
      `{
    "name" : "FAO:John Smith",
    "company" : "Star Clothing Boutique",
    "address" : "123 Star Road, City,\\nState 12345",
    "country" : "U.S.A"
}`,
    );
  }
}
