import { StarXpandCommand } from "star-io10-web";

export class LabelSample10_For203dpiAnd300dpi_FoodDeliveryLabel {
  static async createPrintCommands(): Promise<string> {
    let builder = new StarXpandCommand.StarXpandCommandBuilder();

    builder.addDocument(
      new StarXpandCommand.DocumentBuilder().addPrinter(
        new StarXpandCommand.PrinterBuilder()
          .add(
            new StarXpandCommand.PrinterBuilder()
              .styleBold(true)
              .styleMagnification(
                new StarXpandCommand.MagnificationParameter(3, 3),
              )
              .actionPrintText("Star Eats\n")
              .add(
                new StarXpandCommand.PrinterBuilder()
                  .styleInvert(true)
                  .actionPrintText("8A720  Micronics\n"),
              ),
          )
          .styleAlignment(StarXpandCommand.Printer.Alignment.Center)
          .actionPrintText("Placed at March 24 2021 1:30PM\n")
          .add(
            new StarXpandCommand.PrinterBuilder()
              .styleUnderLine(true)
              .actionPrintText(
                "                                                \n",
              ),
          )
          .add(
            new StarXpandCommand.PrinterBuilder()
              .styleBold(true)
              .styleMagnification(
                new StarXpandCommand.MagnificationParameter(2, 2),
              )
              .actionPrintText("DELIVERY\n"),
          )
          .add(
            new StarXpandCommand.PrinterBuilder()
              .styleUnderLine(true)
              .actionPrintText(
                "                                                \n",
              ),
          )
          .styleAlignment(StarXpandCommand.Printer.Alignment.Left)
          .actionPrintText(
            "1XStar's lunch box A *                    $10.95\n" +
              "------------------------------------------------\n" +
              "Subtotal                                   $0.97\n" +
              "Amount paid                               $11.92\n" +
              "item 1                                    $10.00\n" +
              "------------------------------------------------\n" +
              "*Use special source as you like!\n",
          )
          .actionCut(StarXpandCommand.Printer.CutType.Partial),
      ),
    );

    return await builder.getCommands();
  }
}
