import { StarXpandCommand } from "star-io10-web";

export class LabelSample07_For203dpiAnd300dpi_DrinkLabel6_Template {
  static async createTemplate(): Promise<string> {
    let builder = new StarXpandCommand.StarXpandCommandBuilder();

    builder.addDocument(
      new StarXpandCommand.DocumentBuilder()
        // Change the printable area setting for this layout according to the printer resolution.
        // 48.0 for 203dpi, 48.7 for 300dpi
        .settingPrintableArea(48.0)
        //.settingPrintableArea(48.7)
        .addPrinter(
          new StarXpandCommand.PrinterBuilder()
            // By setting the base print size of text to x1.5 for 300dpi,
            // you can print text at the same size as 203dpi.
            //.styleBaseMagnification(new BaseMagnificationParameter().setText(BaseMagnification.X1_5))
            .styleAlignment(StarXpandCommand.Printer.Alignment.Center)
            .styleLineSpace(1.0)
            .add(
              new StarXpandCommand.PrinterBuilder()
                .styleMagnification(
                  new StarXpandCommand.MagnificationParameter(1, 2),
                )
                .actionPrintText("${order_types}${order_types_detail}\n"),
            )
            .add(
              new StarXpandCommand.PrinterBuilder()
                .styleMagnification(
                  new StarXpandCommand.MagnificationParameter(2, 2),
                )
                .actionPrintText("#${order_number%04d}\n"),
            )
            .add(
              new StarXpandCommand.PrinterBuilder()
                .styleInvert(true)
                .styleMagnification(
                  new StarXpandCommand.MagnificationParameter(1, 2),
                )
                .actionPrintText(
                  "${number}\n", // ?
                ),
            )
            .actionPrintText("${time}\n")
            .actionPrintText("--------------------------------\n")
            .add(
              new StarXpandCommand.PrinterBuilder()
                .styleAlignment(StarXpandCommand.Printer.Alignment.Left)
                .styleMagnification(
                  new StarXpandCommand.MagnificationParameter(1, 2),
                )
                .actionPrintText("${product_name}\n")
                .add(
                  new StarXpandCommand.PrinterBuilder(
                    new StarXpandCommand.Printer.PrinterParameter().setTemplateExtension(
                      new StarXpandCommand.TemplateExtensionParameter().setEnableArrayFieldData(
                        true,
                      ),
                    ),
                  )
                    .styleHorizontalPositionTo(3.0)
                    .actionPrintText("${item_list.detail}\n"),
                ),
            )
            .actionPrintText("--------------------------------\n")
            .actionCut(StarXpandCommand.Printer.CutType.Partial),
        ),
    );
    return await builder.getCommands();
  }

  static async getFieldData(): Promise<string> {
    return Promise.resolve(
      `{
    "order_types" : "Delivery:",
    "order_types_detail" : "Star Eats",
    "order_number" : 8026,
    "number" : "*****7A9CE",
    "time" : "9:29:11 AM",
    "product_name" : "Star Cappuccino",
    "item_list" : [
        {
            "detail" : "ButrPecn Swrl"
        },
        {
            "detail" : "Caramel Swrl"
        },
        {
            "detail" : "FrenchVanilla Swrl"
        },
        {
            "detail" : "Vanilla Shot"
        },
        {
            "detail" : "Hazelnut Shot"
        },
        {
            "detail" : "Toastd Almond Shot"
        },
        {
            "detail" : "Coconut Shot"
        },
        {
            "detail" : "Liquid Cane Sugar"
        },
        {
            "detail" : "Milk"
        }
    ]
}`,
    );
  }
}
