﻿import { StarXpandCommand } from "star-io10-web";

export class LabelSample14_For203dpi_BarbellLabel_Template {
  static async createTemplate(): Promise<string> {
    let builder = new StarXpandCommand.StarXpandCommandBuilder();

    builder.addDocument(
      new StarXpandCommand.DocumentBuilder()
        .settingPrintableArea(54.0)
        .addPrinter(
          new StarXpandCommand.PrinterBuilder()
            .addPageMode(
              new StarXpandCommand.Printer.PageModeAreaParameter(54.0, 27.0),
              new StarXpandCommand.PageModeBuilder()
                .styleHorizontalPositionTo(5.0)
                .styleVerticalPositionTo(5.0)
                .actionPrintBarcode(
                  new StarXpandCommand.Printer.BarcodeParameter(
                    "${barcode}",
                    StarXpandCommand.Printer.BarcodeSymbology.Code128,
                  )
                    .setBarDots(2)
                    .setHeight(4.0)
                    .setPrintHri(true),
                )
                .styleHorizontalPositionTo(32.0)
                .styleVerticalPositionTo(4.0)
                .actionPrintText(
                  "${product_name}",
                  new StarXpandCommand.Printer.TextParameter().setWidth(
                    12,
                    new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                      StarXpandCommand.Printer.TextAlignment.Center,
                    ),
                  ),
                )
                .styleVerticalPositionBy(3.0)
                .styleHorizontalPositionTo(32.0)
                .actionPrintText(
                  "$${price%.2f}\n",
                  new StarXpandCommand.Printer.TextParameter().setWidth(
                    12,
                    new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                      StarXpandCommand.Printer.TextAlignment.Center,
                    ),
                  ),
                )

                .styleHorizontalPositionTo(5.0)
                .styleVerticalPositionTo(16.0)
                .actionPrintBarcode(
                  new StarXpandCommand.Printer.BarcodeParameter(
                    "${barcode}",
                    StarXpandCommand.Printer.BarcodeSymbology.Code128,
                  )
                    .setBarDots(2)
                    .setHeight(4.0)
                    .setPrintHri(true),
                )
                .styleHorizontalPositionTo(32.0)
                .styleVerticalPositionTo(15.0)
                .actionPrintText(
                  "${product_name}",
                  new StarXpandCommand.Printer.TextParameter().setWidth(
                    12,
                    new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                      StarXpandCommand.Printer.TextAlignment.Center,
                    ),
                  ),
                )
                .styleVerticalPositionBy(3.0)
                .styleHorizontalPositionTo(32.0)
                .actionPrintText(
                  "$${price%.2f}\n",
                  new StarXpandCommand.Printer.TextParameter().setWidth(
                    12,
                    new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                      StarXpandCommand.Printer.TextAlignment.Center,
                    ),
                  ),
                ),
            )
            .actionCut(StarXpandCommand.Printer.CutType.Partial),
        ),
    );
    return await builder.getCommands();
  }

  static async getFieldData(): Promise<string> {
    return Promise.resolve(
      `{
    "barcode" : "012345",
    "product_name" : "PRODUCT NAME",
    "price" : 9.99
}`,
    );
  }
}
