﻿import { StarXpandCommand } from "star-io10-web";

export class LabelSample12_For203dpi_FoodSafetyInfo_Template {
  static async createTemplate(): Promise<string> {
    let builder = new StarXpandCommand.StarXpandCommandBuilder();

    builder.addDocument(
      new StarXpandCommand.DocumentBuilder()
        .settingPrintableArea(72.0)
        .addPrinter(
          new StarXpandCommand.PrinterBuilder()
            .addPageMode(
              new StarXpandCommand.Printer.PageModeAreaParameter(72.0, 58.0),
              new StarXpandCommand.PageModeBuilder()
                .actionPrintRectangle(
                  new StarXpandCommand.Printer.PageModeRectangleParameter(
                    0.0,
                    0.0,
                    72.0,
                    58.0,
                  ),
                )
                .styleFont(StarXpandCommand.Printer.FontType.B)
                .addPageMode(
                  new StarXpandCommand.Printer.PageModeAreaParameter(68.0, 58.0)
                    .setX(2.0)
                    .setY(0.0),
                  new StarXpandCommand.PageModeBuilder()
                    .styleMagnification(
                      new StarXpandCommand.MagnificationParameter(3, 3),
                    )
                    .styleVerticalPositionTo(6.0)
                    .actionPrintText(
                      "FOOD SAFETY INFO\n",
                      new StarXpandCommand.Printer.TextParameter().setWidth(
                        20,
                        new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                          StarXpandCommand.Printer.TextAlignment.Center,
                        ),
                      ),
                    )
                    .styleMagnification(
                      new StarXpandCommand.MagnificationParameter(2, 2),
                    )
                    .styleVerticalPositionBy(8.0)
                    .actionPrintText("Item:")
                    .styleHorizontalPositionBy(1.0)
                    .styleUnderLine(true)
                    .actionPrintText(
                      "${item_name}\n",
                      new StarXpandCommand.Printer.TextParameter().setWidth(24),
                    )
                    .styleUnderLine(false)
                    .styleVerticalPositionBy(10.0)
                    .actionPrintText("Prepared Date:")
                    .styleHorizontalPositionBy(1.0)
                    .styleUnderLine(true)
                    .actionPrintText(
                      "${prepared_date}\n",
                      new StarXpandCommand.Printer.TextParameter().setWidth(15),
                    )
                    .styleUnderLine(false)
                    .styleVerticalPositionBy(10.0)
                    .actionPrintText("Use By Date:")
                    .styleHorizontalPositionBy(1.0)
                    .styleUnderLine(true)
                    .actionPrintText(
                      "${use_by_date}\n",
                      new StarXpandCommand.Printer.TextParameter().setWidth(17),
                    ),
                )
                .styleHorizontalPositionTo(3.0)
                .styleVerticalPositionTo(21.0)
                .actionPrintText("Producto\n")
                .styleHorizontalPositionTo(3.0)
                .styleVerticalPositionTo(35.0)
                .actionPrintText("Fecha de preparación\n")
                .styleHorizontalPositionTo(3.0)
                .styleVerticalPositionTo(49.0)
                .actionPrintText("Fecha de expiración\n"),
            )
            .actionCut(StarXpandCommand.Printer.CutType.Partial),
        ),
    );
    return await builder.getCommands();
  }

  static async getFieldData(): Promise<string> {
    return Promise.resolve(
      `{
    "item_name" : "Star Pizza",
    "prepared_date" : "12/25/2023",
    "use_by_date" : "12/26/2023"
}`,
    );
  }
}
