import { StarXpandCommand } from "star-io10-web";

export class LabelSample09_For203dpi_CleanedAndSanitised_Template {
  static async createTemplate(): Promise<string> {
    let builder = new StarXpandCommand.StarXpandCommandBuilder();

    builder.addDocument(
      new StarXpandCommand.DocumentBuilder()
        .settingPrintableArea(72.0)
        .addPrinter(
          new StarXpandCommand.PrinterBuilder()
            .addPageMode(
              new StarXpandCommand.Printer.PageModeAreaParameter(72.0, 40.0),
              new StarXpandCommand.PageModeBuilder()
                .actionPrintRectangle(
                  new StarXpandCommand.Printer.PageModeRectangleParameter(
                    0.0,
                    0.0,
                    18.0,
                    18.0,
                  ).setThickness(0.8),
                )
                .actionPrintRectangle(
                  new StarXpandCommand.Printer.PageModeRectangleParameter(
                    0.0,
                    20.0,
                    72.0,
                    20.0,
                  ).setThickness(0.8),
                )
                .actionPrintImage(
                  new StarXpandCommand.Printer.PageModeImageParameter(
                    "cleanedsanitised_hand.png",
                    1.0,
                    1.0,
                    130,
                  ),
                )
                .addPageMode(
                  new StarXpandCommand.Printer.PageModeAreaParameter(50.0, 20.0)
                    .setX(22.0)
                    .setY(0.0),
                  new StarXpandCommand.PageModeBuilder()
                    .styleBold(true)
                    .styleMagnification(
                      new StarXpandCommand.MagnificationParameter(2, 2),
                    )
                    .styleVerticalPositionTo(3.0)
                    .actionPrintText("CLEANED\n")
                    .styleVerticalPositionBy(4.0)
                    .actionPrintText("& SANITISED\n"),
                )
                .styleHorizontalPositionTo(2.0)
                .styleVerticalPositionTo(21.0)
                .actionPrintText("Name:")
                .styleHorizontalPositionTo(45.0)
                .actionPrintText("Date:")
                .styleHorizontalPositionTo(2.0)
                .styleMagnification(
                  new StarXpandCommand.MagnificationParameter(1, 2),
                )
                .styleVerticalPositionBy(10.0)
                .actionPrintText(
                  "${name}",
                  new StarXpandCommand.Printer.TextParameter().setWidth(28),
                )
                .actionPrintText(" ")
                .actionPrintText(
                  "${date}",
                  new StarXpandCommand.Printer.TextParameter().setWidth(16),
                ),
            )
            .actionCut(StarXpandCommand.Printer.CutType.Partial),
        ),
    );
    return await builder.getCommands();
  }

  static async getFieldData(): Promise<string> {
    return Promise.resolve(
      `{
    "name" : "John Smith",
    "date" : "12/20/2024"
}`,
    );
  }
}
