import { StarXpandCommand } from "star-io10-web";

export class LabelSample08_For203dpi_AllergenWarning_Template {
  static async createTemplate(): Promise<string> {
    let builder = new StarXpandCommand.StarXpandCommandBuilder();

    builder.addDocument(
      new StarXpandCommand.DocumentBuilder()
        .settingPrintableArea(72.0)
        .addPrinter(
          new StarXpandCommand.PrinterBuilder()
            .addPageMode(
              new StarXpandCommand.Printer.PageModeAreaParameter(72.0, 58.0),
              new StarXpandCommand.PageModeBuilder()
                .actionPrintRectangle(
                  new StarXpandCommand.Printer.PageModeRectangleParameter(
                    0.0,
                    0.0,
                    72.0,
                    58.0,
                  ),
                )
                .add(
                  new StarXpandCommand.PageModeBuilder()
                    .styleMagnification(
                      new StarXpandCommand.MagnificationParameter(2, 2),
                    )
                    .styleVerticalPositionTo(0.0)
                    .actionPrintText(
                      "ALLERGEN WARNING\n",
                      new StarXpandCommand.Printer.TextParameter().setWidth(
                        24,
                        new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                          StarXpandCommand.Printer.TextAlignment.Center,
                        ),
                      ),
                    )
                    .styleHorizontalPositionTo(5.0)
                    .styleVerticalPositionBy(7.0)
                    .actionPrintText("Item: ")
                    .styleUnderLine(true)
                    .actionPrintText(
                      "${item}\n",
                      new StarXpandCommand.Printer.TextParameter().setWidth(14),
                    )
                    .styleHorizontalPositionTo(5.0)
                    .styleUnderLine(false)
                    .styleVerticalPositionBy(5.0)
                    .actionPrintText("Date: ")
                    .styleUnderLine(true)
                    .actionPrintText(
                      "${date}\n",
                      new StarXpandCommand.Printer.TextParameter().setWidth(14),
                    )
                    .styleUnderLine(false),
                )
                .actionPrintRectangle(
                  new StarXpandCommand.Printer.PageModeRectangleParameter(
                    2.0,
                    30.0,
                    4.0,
                    4.0,
                  ),
                )
                .actionPrintRectangle(
                  new StarXpandCommand.Printer.PageModeRectangleParameter(
                    25.0,
                    30.0,
                    4.0,
                    4.0,
                  ),
                )
                .actionPrintRectangle(
                  new StarXpandCommand.Printer.PageModeRectangleParameter(
                    48.0,
                    30.0,
                    4.0,
                    4.0,
                  ),
                )
                .styleHorizontalPositionTo(3.0)
                .styleVerticalPositionTo(31.0)
                .actionPrintText(
                  "${dairy}",
                  new StarXpandCommand.Printer.TextParameter().setWidth(1),
                )
                .styleHorizontalPositionBy(4.0)
                .actionPrintText("Dairy")
                .styleHorizontalPositionTo(26.0)
                .actionPrintText(
                  "${fish}",
                  new StarXpandCommand.Printer.TextParameter().setWidth(1),
                )
                .styleHorizontalPositionBy(4.0)
                .actionPrintText("Fish")
                .styleHorizontalPositionTo(49.0)
                .actionPrintText(
                  "${eggs}",
                  new StarXpandCommand.Printer.TextParameter().setWidth(1),
                )
                .styleHorizontalPositionBy(4.0)
                .actionPrintText("Eggs")
                .actionPrintRectangle(
                  new StarXpandCommand.Printer.PageModeRectangleParameter(
                    2.0,
                    36.0,
                    4.0,
                    4.0,
                  ),
                )
                .actionPrintRectangle(
                  new StarXpandCommand.Printer.PageModeRectangleParameter(
                    25.0,
                    36.0,
                    4.0,
                    4.0,
                  ),
                )
                .actionPrintRectangle(
                  new StarXpandCommand.Printer.PageModeRectangleParameter(
                    48.0,
                    36.0,
                    4.0,
                    4.0,
                  ),
                )
                .styleHorizontalPositionTo(3.0)
                .styleVerticalPositionTo(37.0)
                .actionPrintText(
                  "${peanuts}",
                  new StarXpandCommand.Printer.TextParameter().setWidth(1),
                )
                .styleHorizontalPositionBy(4.0)
                .actionPrintText("Peanuts")
                .styleHorizontalPositionTo(26.0)
                .actionPrintText(
                  "${shellfish}",
                  new StarXpandCommand.Printer.TextParameter().setWidth(1),
                )
                .styleHorizontalPositionBy(4.0)
                .actionPrintText("Shellfish")
                .styleHorizontalPositionTo(49.0)
                .actionPrintText(
                  "${soy}",
                  new StarXpandCommand.Printer.TextParameter().setWidth(1),
                )
                .styleHorizontalPositionBy(4.0)
                .actionPrintText("Soy")
                .actionPrintRectangle(
                  new StarXpandCommand.Printer.PageModeRectangleParameter(
                    2.0,
                    42.0,
                    4.0,
                    4.0,
                  ),
                )
                .actionPrintRectangle(
                  new StarXpandCommand.Printer.PageModeRectangleParameter(
                    25.0,
                    42.0,
                    4.0,
                    4.0,
                  ),
                )
                .actionPrintRectangle(
                  new StarXpandCommand.Printer.PageModeRectangleParameter(
                    48.0,
                    42.0,
                    4.0,
                    4.0,
                  ),
                )
                .styleHorizontalPositionTo(3.0)
                .styleVerticalPositionTo(43.0)
                .actionPrintText(
                  "${treenuts}",
                  new StarXpandCommand.Printer.TextParameter().setWidth(1),
                )
                .styleHorizontalPositionBy(4.0)
                .actionPrintText("Tree Nuts")

                .styleHorizontalPositionTo(26.0)
                .actionPrintText(
                  "${wheat}",
                  new StarXpandCommand.Printer.TextParameter().setWidth(1),
                )
                .styleHorizontalPositionBy(4.0)
                .actionPrintText("Wheat")
                .styleHorizontalPositionTo(49.0)
                .actionPrintText(
                  "${gluten}",
                  new StarXpandCommand.Printer.TextParameter().setWidth(1),
                )
                .styleHorizontalPositionBy(4.0)
                .actionPrintText("Gluten")
                .styleHorizontalPositionTo(9.0)
                .styleVerticalPositionBy(8.0)
                .actionPrintText("Other: ")
                .styleUnderLine(true)
                .actionPrintText(
                  "${other}\n",
                  new StarXpandCommand.Printer.TextParameter().setWidth(32),
                ),
            )
            .actionCut(StarXpandCommand.Printer.CutType.Partial),
        ),
    );
    return await builder.getCommands();
  }

  static async getFieldData(): Promise<string> {
    return Promise.resolve(
      `{
    "item" : "Star Pizza",
    "date" : "12/20/2024",
    "dairy" : "",
    "fish" : "X",
    "eggs" : "X",
    "peanuts" : "",
    "shellfish" : "",
    "soy" : "",
    "treenuts" : "X",
    "wheat" : "",
    "gluten" : "",
    "other" : "shrimp, salmon"
}`,
    );
  }
}
