/*
 * Decompiled with CFR 0.152.
 */
package com.starmicronics.utility.POSPrinter.Star;

import com.starmicronics.utility.POSPrinter.MapModeConversion;
import com.starmicronics.utility.POSPrinter.PrinterFont;
import com.starmicronics.utility.POSPrinter.Star.CommandStar;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import jpos.JposException;
import jpos.config.JposEntry;

public class CommandStarDot
extends CommandStar {
    private boolean m_cap18Pin = false;
    private boolean m_capRecPartialCut = false;
    private boolean m_capRecFullCut = false;
    private byte m_multipleHeightCommand = 0;
    private byte m_multipleWidthCommand = 0;
    private MapModeConversion m_mapMode;

    public CommandStarDot(PrinterFont printerFont, MapModeConversion mapModeConversion, JposEntry jposEntry) {
        super(printerFont, jposEntry);
        this.m_mapMode = mapModeConversion;
        this.m_capRecPartialCut = (Boolean)jposEntry.getPropertyValue("partialCut");
        this.m_capRecFullCut = (Boolean)jposEntry.getPropertyValue("fullCut");
        this.m_cap18Pin = (Boolean)jposEntry.getPropertyValue("cap18Pin");
    }

    public List initializeCommand() {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        arrayList.add(new byte[]{27, 29, 116, this.m_printerFont.getCharacterSetByteCommand()});
        arrayList.add(new byte[]{27, this.m_printerFont.getFontSelect()});
        arrayList.add(new byte[]{27, 32, this.m_printerFont.getRightSideCharacterSpacing()});
        arrayList.add(new byte[]{27, 65, (byte)this.m_printerFont.getDotLineSpacing()});
        arrayList.add(new byte[]{27, 50});
        arrayList.add(new byte[]{27, 70});
        arrayList.add(new byte[]{27, 45, 48});
        arrayList.add(new byte[]{27, 53});
        arrayList.add(new byte[]{20});
        arrayList.add(new byte[]{27, 104, 48});
        arrayList.add(new byte[]{27, 29, 97, 48});
        return arrayList;
    }

    public List barCodeCommand(String string, int n, int n2, int n3, int n4, int n5) throws JposException {
        throw new JposException(106, "This request is illegal because the specified station is unsupported.");
    }

    public byte[] paperCutCommand(int n, boolean bl, boolean bl2) throws JposException {
        byte[] byArray = new byte[]{27, 100, 0};
        if (100 <= n) {
            byArray[2] = bl ? 2 : 0;
        } else if (0 >= n) {
            if (0 > n) {
                throw new JposException(106, "This request is illegal");
            }
            if (bl) {
                if (this.m_capRecPartialCut) {
                    byArray[1] = 74;
                    byArray[2] = 72;
                } else {
                    byArray[2] = 116;
                }
            }
        } else {
            byArray[2] = bl ? (!this.m_capRecPartialCut ? 116 : 3) : 1;
        }
        return byArray;
    }

    protected void multipleHeightSetting(int n, boolean bl) throws JposException {
        if (n < 1) {
            if (bl) {
                throw new JposException(106, "This request is illegal and set character size to normal.");
            }
            this.m_multipleHeightCommand = 0;
        } else if (n > 2) {
            if (bl) {
                throw new JposException(106, "This request is illegal and print with the height scaled 2 times the normal size.");
            }
            this.m_multipleHeightCommand = 1;
        } else {
            this.m_multipleHeightCommand = (byte)(n - 1);
        }
    }

    protected void multipleWidthSetting(int n, boolean bl) throws JposException {
        if (n < 1) {
            if (bl) {
                throw new JposException(106, "This request is illegal and set character size to normal.");
            }
            this.m_multipleWidthCommand = (byte)20;
        } else if (n > 2) {
            if (bl) {
                throw new JposException(106, "This request is illegal and set character size to 2 width.");
            }
            this.m_multipleWidthCommand = (byte)14;
        } else {
            this.m_multipleWidthCommand = 1 == n ? (byte)20 : (byte)14;
        }
    }

    protected byte[] multipleHeightAndWidthCommand() throws JposException {
        return new byte[]{this.m_multipleWidthCommand, 27, 104, this.m_multipleHeightCommand};
    }

    protected byte[] feedUnitsCommand(int n, boolean bl) throws JposException {
        int n2 = this.m_mapMode.mapModeToDotHeight(n);
        if (1 > n2) {
            if (bl) {
                throw new JposException(106, "This request is illegal and feed 1 dot.");
            }
            n2 = 1;
        } else if (255 < n2) {
            if (bl) {
                throw new JposException(106, "This request is illegal and feed 255 dots.");
            }
            n2 = 255;
        }
        return new byte[]{27, 74, (byte)n2};
    }

    protected byte[] feedReverseCommand(int n, boolean bl) throws JposException {
        byte[] byArray = new byte[]{27, 106, 0};
        if (n < 1) {
            byArray[2] = 1;
            if (bl) {
                throw new JposException(106, "This request is illegal and feed 1 line reversed.");
            }
        } else if (n > 255) {
            byArray[2] = -1;
            if (bl) {
                throw new JposException(106, "This request is illegal and feed 255lines reversed.");
            }
        } else {
            byArray[2] = (byte)n;
        }
        return byArray;
    }

    public List bitmapCommand(Image image, int n, int n2, int n3) throws JposException {
        int n4 = 0;
        BufferedImage bufferedImage = null;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        this.addArrayListElementsFirst(this.initializeCommand(), arrayList);
        try {
            if (n != -11) {
                image = new ImageIcon(image.getScaledInstance(n, -1, 1)).getImage();
            }
            if (this.m_cap18Pin) {
                image = new ImageIcon(image.getScaledInstance(image.getWidth(null), image.getHeight(null) * 2, 4)).getImage();
            }
            n = image.getWidth(null);
            n4 = image.getHeight(null);
        }
        catch (Exception exception) {
            throw new JposException(114, 207);
        }
        if (n <= 0) {
            throw new JposException(106, "This request failed because the bitmap width is 0.");
        }
        if (n > this.m_printerFont.getLineWidthDot()) {
            throw new JposException(114, 206);
        }
        if (n2 == -1) {
            n2 = 0;
        } else if (n2 == -2) {
            n2 = (this.m_printerFont.getLineWidthDot() - n) / 2;
        } else if (n2 == -3) {
            n2 = this.m_printerFont.getLineWidthDot() - n;
        } else if (0 > this.m_printerFont.getLineWidthDot() - n2 - n) {
            throw new JposException(106, "This request failed because the aligment parameter is not valid.");
        }
        if (n4 <= 0) {
            throw new JposException(106, "This request failed because the bitmap height is 0.");
        }
        try {
            bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(0, 0, image.getWidth(null), image.getHeight(null));
            graphics2D.drawImage(image, 0, 0, null);
            graphics2D.dispose();
        }
        catch (Exception exception) {
            throw new JposException(114, 207);
        }
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        n5 = this.m_printerFont.getLineWidthDot() - n2 - n - 1 > 0 ? (this.m_cap18Pin ? (n4 % 16 != 0 ? 1 + (4 + (5 + n * 2) + 4 + 7 + 3) * (n4 / 16 + 1) : 1 + (4 + (5 + n * 2) + 4 + 7 + 3) * (n4 / 16)) : (n4 % 8 != 0 ? 1 + (4 + (4 + n) + 4 + 5 + 3) * (n4 / 8 + 1) : 1 + (4 + (4 + n) + 4 + 5 + 3) * (n4 / 8))) : (this.m_cap18Pin ? (n4 % 16 != 0 ? 1 + (4 + (5 + n * 2) + 7 + 3) * (n4 / 16 + 1) : 1 + (4 + (5 + n * 2) + 7 + 3) * (n4 / 16)) : (n4 % 8 != 0 ? 1 + (4 + (4 + n) + 5 + 3) * (n4 / 8 + 1) : 1 + (4 + (4 + n) + 5 + 3) * (n4 / 8)));
        byte[] byArray = new byte[n5];
        while (n6 < n5) {
            byArray[n6++] = 0;
        }
        n6 = 0;
        byArray[n6++] = 1 == this.getRotateBitmap() ? 18 : 15;
        try {
            if (this.m_cap18Pin) {
                for (n7 = 0; n7 < n4; n7 += 16) {
                    byArray[n6++] = 27;
                    byArray[n6++] = 9;
                    byArray[n6++] = (byte)(n2 * 2 % 256);
                    byArray[n6++] = (byte)(n2 * 2 / 256);
                    byArray[n6++] = 27;
                    byArray[n6++] = 94;
                    byArray[n6++] = 2;
                    byArray[n6++] = (byte)(n % 256);
                    byArray[n6++] = (byte)(n / 256);
                    switch (n3) {
                        case 1: {
                            n8 = 0;
                            while (n8 < n) {
                                switch (n4 - n7) {
                                    default: {
                                        if (this.convertColor2Mono(bufferedImage.getRGB(n8, n7 + 15))) {
                                            int n9 = n6 + 1;
                                            byArray[n9] = (byte)(byArray[n9] | 1);
                                        }
                                    }
                                    case 15: {
                                        if (this.convertColor2Mono(bufferedImage.getRGB(n8, n7 + 14))) {
                                            int n10 = n6 + 1;
                                            byArray[n10] = (byte)(byArray[n10] | 2);
                                        }
                                    }
                                    case 14: {
                                        if (this.convertColor2Mono(bufferedImage.getRGB(n8, n7 + 13))) {
                                            int n11 = n6 + 1;
                                            byArray[n11] = (byte)(byArray[n11] | 4);
                                        }
                                    }
                                    case 13: {
                                        if (this.convertColor2Mono(bufferedImage.getRGB(n8, n7 + 12))) {
                                            int n12 = n6 + 1;
                                            byArray[n12] = (byte)(byArray[n12] | 8);
                                        }
                                    }
                                    case 12: {
                                        if (this.convertColor2Mono(bufferedImage.getRGB(n8, n7 + 11))) {
                                            int n13 = n6 + 1;
                                            byArray[n13] = (byte)(byArray[n13] | 0x10);
                                        }
                                    }
                                    case 11: {
                                        if (this.convertColor2Mono(bufferedImage.getRGB(n8, n7 + 10))) {
                                            int n14 = n6 + 1;
                                            byArray[n14] = (byte)(byArray[n14] | 0x20);
                                        }
                                    }
                                    case 10: {
                                        if (this.convertColor2Mono(bufferedImage.getRGB(n8, n7 + 9))) {
                                            int n15 = n6 + 1;
                                            byArray[n15] = (byte)(byArray[n15] | 0x40);
                                        }
                                    }
                                    case 9: {
                                        if (this.convertColor2Mono(bufferedImage.getRGB(n8, n7 + 8))) {
                                            int n16 = n6 + 1;
                                            byArray[n16] = (byte)(byArray[n16] | 0x80);
                                        }
                                    }
                                    case 8: {
                                        if (this.convertColor2Mono(bufferedImage.getRGB(n8, n7 + 7))) {
                                            int n17 = n6;
                                            byArray[n17] = (byte)(byArray[n17] | 1);
                                        }
                                    }
                                    case 7: {
                                        if (this.convertColor2Mono(bufferedImage.getRGB(n8, n7 + 6))) {
                                            int n18 = n6;
                                            byArray[n18] = (byte)(byArray[n18] | 2);
                                        }
                                    }
                                    case 6: {
                                        if (this.convertColor2Mono(bufferedImage.getRGB(n8, n7 + 5))) {
                                            int n19 = n6;
                                            byArray[n19] = (byte)(byArray[n19] | 4);
                                        }
                                    }
                                    case 5: {
                                        if (this.convertColor2Mono(bufferedImage.getRGB(n8, n7 + 4))) {
                                            int n20 = n6;
                                            byArray[n20] = (byte)(byArray[n20] | 8);
                                        }
                                    }
                                    case 4: {
                                        if (this.convertColor2Mono(bufferedImage.getRGB(n8, n7 + 3))) {
                                            int n21 = n6;
                                            byArray[n21] = (byte)(byArray[n21] | 0x10);
                                        }
                                    }
                                    case 3: {
                                        if (this.convertColor2Mono(bufferedImage.getRGB(n8, n7 + 2))) {
                                            int n22 = n6;
                                            byArray[n22] = (byte)(byArray[n22] | 0x20);
                                        }
                                    }
                                    case 2: {
                                        if (!this.convertColor2Mono(bufferedImage.getRGB(n8, n7 + 1))) break;
                                        int n23 = n6;
                                        byArray[n23] = (byte)(byArray[n23] | 0x40);
                                    }
                                    case 1: 
                                }
                                if (this.convertColor2Mono(bufferedImage.getRGB(n8, n7))) {
                                    int n24 = n6;
                                    byArray[n24] = (byte)(byArray[n24] | 0x80);
                                }
                                ++n8;
                                n6 += 2;
                            }
                            break;
                        }
                        case 259: {
                            n8 = 0;
                            while (n8 < n) {
                                switch (n4 - n7) {
                                    default: {
                                        if (this.convertColor2Mono(bufferedImage.getRGB(n8, n4 - n7 - 16))) {
                                            int n25 = n6;
                                            byArray[n25] = (byte)(byArray[n25] | 0x80);
                                        }
                                    }
                                    case 15: {
                                        if (this.convertColor2Mono(bufferedImage.getRGB(n8, n4 - n7 - 15))) {
                                            int n26 = n6;
                                            byArray[n26] = (byte)(byArray[n26] | 0x40);
                                        }
                                    }
                                    case 14: {
                                        if (this.convertColor2Mono(bufferedImage.getRGB(n8, n4 - n7 - 14))) {
                                            int n27 = n6;
                                            byArray[n27] = (byte)(byArray[n27] | 0x20);
                                        }
                                    }
                                    case 13: {
                                        if (this.convertColor2Mono(bufferedImage.getRGB(n8, n4 - n7 - 13))) {
                                            int n28 = n6;
                                            byArray[n28] = (byte)(byArray[n28] | 0x10);
                                        }
                                    }
                                    case 12: {
                                        if (this.convertColor2Mono(bufferedImage.getRGB(n8, n4 - n7 - 12))) {
                                            int n29 = n6;
                                            byArray[n29] = (byte)(byArray[n29] | 8);
                                        }
                                    }
                                    case 11: {
                                        if (this.convertColor2Mono(bufferedImage.getRGB(n8, n4 - n7 - 11))) {
                                            int n30 = n6;
                                            byArray[n30] = (byte)(byArray[n30] | 4);
                                        }
                                    }
                                    case 10: {
                                        if (this.convertColor2Mono(bufferedImage.getRGB(n8, n4 - n7 - 10))) {
                                            int n31 = n6;
                                            byArray[n31] = (byte)(byArray[n31] | 2);
                                        }
                                    }
                                    case 9: {
                                        if (this.convertColor2Mono(bufferedImage.getRGB(n8, n4 - n7 - 9))) {
                                            int n32 = n6;
                                            byArray[n32] = (byte)(byArray[n32] | 1);
                                        }
                                    }
                                    case 8: {
                                        if (this.convertColor2Mono(bufferedImage.getRGB(n8, n4 - n7 - 8))) {
                                            int n33 = n6 + 1;
                                            byArray[n33] = (byte)(byArray[n33] | 0x80);
                                        }
                                    }
                                    case 7: {
                                        if (this.convertColor2Mono(bufferedImage.getRGB(n8, n4 - n7 - 7))) {
                                            int n34 = n6 + 1;
                                            byArray[n34] = (byte)(byArray[n34] | 0x40);
                                        }
                                    }
                                    case 6: {
                                        if (this.convertColor2Mono(bufferedImage.getRGB(n8, n4 - n7 - 6))) {
                                            int n35 = n6 + 1;
                                            byArray[n35] = (byte)(byArray[n35] | 0x20);
                                        }
                                    }
                                    case 5: {
                                        if (this.convertColor2Mono(bufferedImage.getRGB(n8, n4 - n7 - 5))) {
                                            int n36 = n6 + 1;
                                            byArray[n36] = (byte)(byArray[n36] | 0x10);
                                        }
                                    }
                                    case 4: {
                                        if (this.convertColor2Mono(bufferedImage.getRGB(n8, n4 - n7 - 4))) {
                                            int n37 = n6 + 1;
                                            byArray[n37] = (byte)(byArray[n37] | 8);
                                        }
                                    }
                                    case 3: {
                                        if (this.convertColor2Mono(bufferedImage.getRGB(n8, n4 - n7 - 3))) {
                                            int n38 = n6 + 1;
                                            byArray[n38] = (byte)(byArray[n38] | 4);
                                        }
                                    }
                                    case 2: {
                                        if (!this.convertColor2Mono(bufferedImage.getRGB(n8, n4 - n7 - 2))) break;
                                        int n39 = n6 + 1;
                                        byArray[n39] = (byte)(byArray[n39] | 2);
                                    }
                                    case 1: 
                                }
                                if (this.convertColor2Mono(bufferedImage.getRGB(n8, n4 - n7 - 1))) {
                                    int n40 = n6 + 1;
                                    byArray[n40] = (byte)(byArray[n40] | 1);
                                }
                                ++n8;
                                n6 += 2;
                            }
                            break;
                        }
                    }
                    if (this.m_printerFont.getLineWidthDot() - n2 - n - 1 > 0) {
                        byArray[n6++] = 27;
                        byArray[n6++] = 9;
                        byArray[n6++] = (byte)((this.m_printerFont.getLineWidthDot() - n2 - n - 1) * 2 % 256);
                        byArray[n6++] = (byte)((this.m_printerFont.getLineWidthDot() - n2 - n - 1) * 2 / 256);
                    }
                    byArray[n6++] = 27;
                    byArray[n6++] = 94;
                    byArray[n6++] = 2;
                    byArray[n6++] = 1;
                    byArray[n6++] = 0;
                    byArray[n6++] = 0;
                    byArray[n6++] = 0;
                    byArray[n6++] = 27;
                    byArray[n6++] = 74;
                    byArray[n6++] = 8;
                }
            } else {
                for (n7 = 0; n7 < n4; n7 += 8) {
                    byArray[n6++] = 27;
                    byArray[n6++] = 9;
                    byArray[n6++] = (byte)(n2 * 2 % 256);
                    byArray[n6++] = (byte)(n2 * 2 / 256);
                    byArray[n6++] = 27;
                    byArray[n6++] = 75;
                    byArray[n6++] = (byte)(n % 256);
                    byArray[n6++] = (byte)(n / 256);
                    switch (n3) {
                        case 1: {
                            n8 = 0;
                            while (n8 < n) {
                                switch (n4 - n7) {
                                    default: {
                                        if (this.convertColor2Mono(bufferedImage.getRGB(n8, n7 + 7))) {
                                            int n41 = n6;
                                            byArray[n41] = (byte)(byArray[n41] | 1);
                                        }
                                    }
                                    case 7: {
                                        if (this.convertColor2Mono(bufferedImage.getRGB(n8, n7 + 6))) {
                                            int n42 = n6;
                                            byArray[n42] = (byte)(byArray[n42] | 2);
                                        }
                                    }
                                    case 6: {
                                        if (this.convertColor2Mono(bufferedImage.getRGB(n8, n7 + 5))) {
                                            int n43 = n6;
                                            byArray[n43] = (byte)(byArray[n43] | 4);
                                        }
                                    }
                                    case 5: {
                                        if (this.convertColor2Mono(bufferedImage.getRGB(n8, n7 + 4))) {
                                            int n44 = n6;
                                            byArray[n44] = (byte)(byArray[n44] | 8);
                                        }
                                    }
                                    case 4: {
                                        if (this.convertColor2Mono(bufferedImage.getRGB(n8, n7 + 3))) {
                                            int n45 = n6;
                                            byArray[n45] = (byte)(byArray[n45] | 0x10);
                                        }
                                    }
                                    case 3: {
                                        if (this.convertColor2Mono(bufferedImage.getRGB(n8, n7 + 2))) {
                                            int n46 = n6;
                                            byArray[n46] = (byte)(byArray[n46] | 0x20);
                                        }
                                    }
                                    case 2: {
                                        if (!this.convertColor2Mono(bufferedImage.getRGB(n8, n7 + 1))) break;
                                        int n47 = n6;
                                        byArray[n47] = (byte)(byArray[n47] | 0x40);
                                    }
                                    case 1: 
                                }
                                if (this.convertColor2Mono(bufferedImage.getRGB(n8, n7))) {
                                    int n48 = n6;
                                    byArray[n48] = (byte)(byArray[n48] | 0x80);
                                }
                                ++n8;
                                ++n6;
                            }
                            break;
                        }
                        case 259: {
                            n8 = 0;
                            while (n8 < n) {
                                switch (n4 - n7) {
                                    default: {
                                        if (this.convertColor2Mono(bufferedImage.getRGB(n8, n4 - n7 - 8))) {
                                            int n49 = n6;
                                            byArray[n49] = (byte)(byArray[n49] | 0x80);
                                        }
                                    }
                                    case 7: {
                                        if (this.convertColor2Mono(bufferedImage.getRGB(n8, n4 - n7 - 7))) {
                                            int n50 = n6;
                                            byArray[n50] = (byte)(byArray[n50] | 0x40);
                                        }
                                    }
                                    case 6: {
                                        if (this.convertColor2Mono(bufferedImage.getRGB(n8, n4 - n7 - 6))) {
                                            int n51 = n6;
                                            byArray[n51] = (byte)(byArray[n51] | 0x20);
                                        }
                                    }
                                    case 5: {
                                        if (this.convertColor2Mono(bufferedImage.getRGB(n8, n4 - n7 - 5))) {
                                            int n52 = n6;
                                            byArray[n52] = (byte)(byArray[n52] | 0x10);
                                        }
                                    }
                                    case 4: {
                                        if (this.convertColor2Mono(bufferedImage.getRGB(n8, n4 - n7 - 4))) {
                                            int n53 = n6;
                                            byArray[n53] = (byte)(byArray[n53] | 8);
                                        }
                                    }
                                    case 3: {
                                        if (this.convertColor2Mono(bufferedImage.getRGB(n8, n4 - n7 - 3))) {
                                            int n54 = n6;
                                            byArray[n54] = (byte)(byArray[n54] | 4);
                                        }
                                    }
                                    case 2: {
                                        if (!this.convertColor2Mono(bufferedImage.getRGB(n8, n4 - n7 - 2))) break;
                                        int n55 = n6;
                                        byArray[n55] = (byte)(byArray[n55] | 2);
                                    }
                                    case 1: 
                                }
                                if (this.convertColor2Mono(bufferedImage.getRGB(n8, n4 - n7 - 1))) {
                                    int n56 = n6;
                                    byArray[n56] = (byte)(byArray[n56] | 1);
                                }
                                ++n8;
                                ++n6;
                            }
                            break;
                        }
                    }
                    if (this.m_printerFont.getLineWidthDot() - n2 - n - 1 > 0) {
                        byArray[n6++] = 27;
                        byArray[n6++] = 9;
                        byArray[n6++] = (byte)((this.m_printerFont.getLineWidthDot() - n2 - n - 1) * 2 % 256);
                        byArray[n6++] = (byte)((this.m_printerFont.getLineWidthDot() - n2 - n - 1) * 2 / 256);
                    }
                    byArray[n6++] = 27;
                    byArray[n6++] = 75;
                    byArray[n6++] = 1;
                    byArray[n6++] = 0;
                    byArray[n6++] = 0;
                    byArray[n6++] = 27;
                    byArray[n6++] = 74;
                    byArray[n6++] = 8;
                }
            }
        }
        catch (Exception exception) {
            throw new JposException(114, 207);
        }
        arrayList.add(byArray);
        return arrayList;
    }
}

