/*
 * Decompiled with CFR 0.152.
 */
package com.starmicronics.starjavapos.Star;

import com.starmicronics.stario.StarIOPort;
import com.starmicronics.stario.StarIOPortException;
import com.starmicronics.stario.StarPrinterStatus;
import com.starmicronics.utility.OutputDataSet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import jpos.JposException;
import jpos.config.JposEntry;
import jpos.events.DataEvent;
import jpos.events.DirectIOEvent;
import jpos.events.ErrorEvent;
import jpos.events.JposEvent;
import jpos.events.OutputCompleteEvent;
import jpos.events.StatusUpdateEvent;
import jpos.services.EventCallbacks;
import jpos.services.MICRService113;

public class MICRStarService
implements MICRService113,
ActionListener {
    int READSTATE;
    static final int INIT = 0;
    static final int MICR = 1;
    static final int NSB = 2;
    static final int MICRSTART = 3;
    private String m_format;
    private boolean m_enabled;
    private StarIOPort m_port;
    private String m_portName;
    private String m_portSettings;
    private EventCallbacks m_eventCallbacks;
    private Object m_eventLock = new Object();
    private Vector m_eventQueue = new Vector();
    private boolean[] m_claimLock;
    private int[] m_serviceState = new int[]{2};
    private boolean m_eventThreadLife = true;
    private Thread m_eventThread;
    private boolean m_statusThreadLife = true;
    private Thread m_statusThread;
    private Object m_statusLock = new Object();
    private StarPrinterStatus[] m_cachedStatus = new StarPrinterStatus[]{new StarPrinterStatus()};
    private int m_ioTimeoutMillis = 5000;
    private int m_ioProgressTimeout = 10000;
    private int[] m_powerNotifyEnabled = new int[]{0};
    private boolean m_slipPaperPresent = false;
    private boolean m_autoDisable;
    private String m_checkHealthText = "";
    private int m_dataCount;
    private boolean m_dataEventEnabled;
    private boolean m_freezeEvents;
    private int[] m_powerState = new int[]{2000};
    private String m_rawData = "";
    private String m_accountNumber = "";
    private String m_amount = "";
    private String m_bankNumber = "";
    private String m_EPC = "";
    private String m_serialNumber = "";
    private String m_transitNumber = "";
    private int m_checkType = 99;
    private int m_countryCode = 99;
    private JButton button;
    private JTextField textField;

    public MICRStarService(JposEntry jposEntry, boolean[] blArray) throws JposException {
        if (!jposEntry.hasPropertyWithName("portName") || jposEntry.getPropertyType("portName") != String.class) {
            throw new JposException(104, "A required configuration property (\"portName\" of type String) is missing.");
        }
        this.m_portName = (String)jposEntry.getPropertyValue("portName");
        if (!jposEntry.hasPropertyWithName("portSettings") || jposEntry.getPropertyType("portSettings") != String.class) {
            throw new JposException(104, "A required configuration property (\"portSettings\" of type String) is missing.");
        }
        this.m_portSettings = (String)jposEntry.getPropertyValue("portSettings");
        if (jposEntry.hasPropertyWithName("ioTimeoutMillis") && jposEntry.getPropertyType("ioTimeoutMillis") == Integer.class) {
            this.m_ioTimeoutMillis = (Integer)jposEntry.getPropertyValue("ioTimeoutMillis");
        }
        if (!jposEntry.hasPropertyWithName("format") || jposEntry.getPropertyType("format") != String.class) {
            throw new JposException(104, "A required configuration property (\"format\" of type String) is missing.");
        }
        this.m_format = (String)jposEntry.getPropertyValue("format");
        this.m_claimLock = blArray;
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void deleteInstance() throws JposException {
        try {
            this.close();
        }
        catch (JposException jposException) {
            // empty catch block
        }
    }

    public String getCheckHealthText() throws JposException {
        return this.m_checkHealthText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getClaimed() throws JposException {
        boolean[] blArray = this.m_claimLock;
        synchronized (this.m_claimLock) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.m_claimLock[0];
        }
    }

    public boolean getDeviceEnabled() throws JposException {
        return this.m_enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDeviceEnabled(boolean bl) throws JposException {
        this.verifyClaimedState();
        if (this.getState() != 2) {
            throw new JposException(106, "This request failed because the device is busy.");
        }
        if (bl == this.m_enabled) {
            return;
        }
        if (bl) {
            try {
                this.m_port = StarIOPort.getPort((String)this.m_portName, (String)this.m_portSettings, (int)this.m_ioTimeoutMillis);
                this.m_cachedStatus[0] = this.m_port.retreiveStatus();
            }
            catch (StarIOPortException starIOPortException) {
                throw new JposException(107, "The device communications channel could not be opened, chech the device and retry.");
            }
            if (null != this.m_eventThread) {
                return;
            }
            this.m_eventThreadLife = true;
            this.m_eventThread = new Thread(new EventServer());
            this.m_eventThread.start();
            if (null != this.m_statusThread) {
                return;
            }
            this.m_statusThreadLife = true;
            this.m_statusThread = new Thread(new StatusServer());
            this.m_statusThread.start();
            this.m_enabled = true;
        } else {
            Object object = this.m_statusLock;
            synchronized (object) {
                this.m_statusThreadLife = false;
                this.m_statusLock.notifyAll();
            }
            try {
                this.m_statusThread.join();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.m_statusThread = null;
            }
            object = this.m_eventLock;
            synchronized (object) {
                this.m_eventThreadLife = false;
                this.m_eventLock.notifyAll();
            }
            try {
                this.m_eventThread.join();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.m_eventThread = null;
            }
            StarIOPort.releasePort((StarIOPort)this.m_port);
            this.m_port = null;
            this.m_enabled = false;
        }
    }

    public String getDeviceServiceDescription() throws JposException {
        return "Star Micronics JavaPOS MICR Service Driver";
    }

    public int getDeviceServiceVersion() throws JposException {
        return 1013012;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getFreezeEvents() throws JposException {
        Object object = this.m_eventLock;
        synchronized (object) {
            return this.m_freezeEvents;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFreezeEvents(boolean bl) throws JposException {
        Object object = this.m_eventLock;
        synchronized (object) {
            this.m_freezeEvents = bl;
            this.m_eventLock.notifyAll();
        }
    }

    public String getPhysicalDeviceDescription() throws JposException {
        return "MICR";
    }

    public String getPhysicalDeviceName() throws JposException {
        return "Star Micronics MICR";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getState() throws JposException {
        int[] nArray = this.m_serviceState;
        synchronized (this.m_serviceState) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.m_serviceState[0];
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void claim(int n) throws JposException {
        if (-1 > n) {
            throw new JposException(106, "The claim operation was aborted because an invalid timeout parameter was specified.");
        }
        boolean[] blArray = this.m_claimLock;
        synchronized (this.m_claimLock) {
            while (this.m_claimLock[0] && 0 < n) {
                try {
                    long l = System.currentTimeMillis();
                    this.m_claimLock.wait(n);
                    long l2 = System.currentTimeMillis() - l;
                    if (l2 > (long)n) {
                        n = 0;
                        continue;
                    }
                    n = (int)((long)n - l2);
                }
                catch (InterruptedException interruptedException) {
                    throw new JposException(106, "The claim operation was aborted because of thread interruption.");
                }
            }
            if (!this.m_claimLock[0]) {
                this.m_claimLock[0] = true;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            throw new JposException(112, "The claim operation timed out");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JposException {
        if (this.getState() != 2) {
            throw new JposException(113, "This request is illegal because the service is busy processing asynchoronous output.");
        }
        try {
            this.setDeviceEnabled(false);
        }
        catch (JposException jposException) {
            // empty catch block
        }
        try {
            this.release();
        }
        catch (JposException jposException) {
            // empty catch block
        }
        if (null != this.m_port) {
            StarIOPort.releasePort((StarIOPort)this.m_port);
            this.m_port = null;
        }
        int[] nArray = this.m_serviceState;
        synchronized (this.m_serviceState) {
            this.m_serviceState[0] = 1;
            // ** MonitorExit[var1_3] (shouldn't be in output)
            return;
        }
    }

    public void checkHealth(int n) throws JposException {
        this.verifyClaimedState();
        this.verifyEnabledState();
        String string = "";
        if (2 == n) {
            this.m_checkHealthText = "Doing checkHealth...\n";
            try {
                this.setDataEventEnabled(true);
            }
            catch (JposException jposException) {
                this.m_checkHealthText = this.m_checkHealthText + "    failure - " + jposException.getMessage() + "\n";
                this.m_checkHealthText = this.m_checkHealthText + "aborted!\n";
                throw jposException;
            }
            this.updateStatus();
            if (!this.m_slipPaperPresent) {
                this.m_checkHealthText = this.m_checkHealthText + "  failure";
                throw new JposException(114, 201, "CheckHealth failed because a check is not detected.\n                    Please insert a check.");
            }
            if (!this.requestScanMicr()) {
                this.beginRemoval(-1);
                this.endRemoval();
                throw new JposException(114, 204, "CheckHealth failed because the entire input data stream was unreadable.\n                    No data is available.");
            }
            try {
                this.m_checkHealthText = this.m_checkHealthText + "  RawData\t= " + this.getRawData() + "\n";
                this.m_checkHealthText = this.m_checkHealthText + "  AccountNumber\t= " + this.getAccountNumber() + "\n";
                this.m_checkHealthText = this.m_checkHealthText + "  BankNumber\t= " + this.getBankNumber() + "\n";
                this.m_checkHealthText = this.m_checkHealthText + "  SerialNumber\t= " + this.getSerialNumber() + "\n";
                this.m_checkHealthText = this.m_checkHealthText + "  TransitNumber\t= " + this.getTransitNumber() + "\n";
                switch (this.getCheckType()) {
                    case 1: {
                        string = "MICR_CT_PERSONAL";
                        break;
                    }
                    case 2: {
                        string = "MICR_CT_BUSINESS";
                        break;
                    }
                    case 99: {
                        string = "MICR_CT_UNKNOWN";
                        break;
                    }
                    default: {
                        string = "MICR_CT_UNKNOWN";
                    }
                }
                this.m_checkHealthText = this.m_checkHealthText + "  CheckType\t= " + string + "\n";
                switch (this.getCountryCode()) {
                    case 1: {
                        string = "MICR_CC_USA";
                        break;
                    }
                    case 2: {
                        string = "MICR_CC_CANADA";
                        break;
                    }
                    case 3: {
                        string = "MICR_CC_MEXICO";
                        break;
                    }
                    case 99: {
                        string = "MICR_CC_UNKNOWN";
                        break;
                    }
                    default: {
                        string = "MICR_CC_UNKNOWN";
                    }
                }
                this.m_checkHealthText = this.m_checkHealthText + "  CountryCode\t= " + string + "\n";
                this.beginRemoval(-1);
                this.endRemoval();
            }
            catch (JposException jposException) {
                this.m_checkHealthText = this.m_checkHealthText + "  failure - " + jposException.getMessage() + "\n";
                this.m_checkHealthText = this.m_checkHealthText + "aborted!\n";
                throw jposException;
            }
            this.m_checkHealthText = this.m_checkHealthText + "success!\n";
        } else if (3 == n) {
            JFrame jFrame = new JFrame("JavaPOS POSPrinter");
            jFrame.setState(1);
            jFrame.setExtendedState(1);
            jFrame.setBounds(0, 0, 0, 0);
            jFrame.setResizable(false);
            jFrame.setUndecorated(true);
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            JDialog jDialog = new JDialog(jFrame, "JavaPOS MICR", true);
            jDialog.setSize(350, 110);
            jDialog.setResizable(false);
            Rectangle rectangle = jDialog.getGraphicsConfiguration().getBounds();
            jDialog.setLocation(rectangle.x + rectangle.width / 2 - jDialog.getSize().width / 2, rectangle.y + rectangle.height / 2 - jDialog.getSize().height / 2);
            Container container = jDialog.getContentPane();
            JPanel jPanel = new JPanel();
            this.button = new JButton("CheckHealth");
            this.button.setPreferredSize(new Dimension(323, 28));
            this.button.addActionListener(this);
            jPanel.add(this.button);
            jDialog.getRootPane().setDefaultButton(this.button);
            container.add((Component)jPanel, "Center");
            JPanel jPanel2 = new JPanel();
            this.textField = new JTextField("");
            this.textField.setPreferredSize(new Dimension(323, 26));
            this.textField.setEditable(false);
            jPanel2.add(this.textField);
            container.add((Component)jPanel2, "Last");
            jDialog.setDefaultCloseOperation(2);
            jFrame.setDefaultCloseOperation(2);
            jFrame.pack();
            jFrame.setVisible(false);
            jDialog.setVisible(true);
            jDialog.hide();
            jFrame.dispose();
        } else {
            throw new JposException(106, "This request failed because the specified checkHealth level is unsupported.");
        }
    }

    public void directIO(int n, int[] nArray, Object object) throws JposException {
        throw new JposException(106, "This request failed because this function is not supported.");
    }

    public synchronized void open(String string, EventCallbacks eventCallbacks) throws JposException {
        this.m_eventCallbacks = eventCallbacks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() throws JposException {
        boolean[] blArray = this.m_claimLock;
        synchronized (this.m_claimLock) {
            if (!this.m_claimLock[0]) {
                throw new JposException(106, "This request is illegal because the service is not already claimed.");
            }
            this.setDeviceEnabled(false);
            this.m_claimLock[0] = false;
            this.m_claimLock.notifyAll();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public boolean getCapValidationDevice() {
        return true;
    }

    public int getCapPowerReporting() throws JposException {
        return 2;
    }

    public boolean getCapStatisticsReporting() throws JposException {
        return false;
    }

    public boolean getCapUpdateStatistics() throws JposException {
        return false;
    }

    public boolean getCapCompareFirmwareVersion() throws JposException {
        return false;
    }

    public boolean getCapUpdateFirmware() throws JposException {
        return false;
    }

    public boolean getAutoDisable() throws JposException {
        return this.m_autoDisable;
    }

    public void setAutoDisable(boolean bl) throws JposException {
        if (bl) {
            throw new JposException(106, "This request failed because this function is not supported.");
        }
        this.m_autoDisable = bl;
    }

    public String getAccountNumber() throws JposException {
        return this.m_accountNumber;
    }

    public String getAmount() throws JposException {
        return this.m_amount;
    }

    public String getBankNumber() throws JposException {
        return this.m_bankNumber;
    }

    public int getCheckType() throws JposException {
        return this.m_checkType;
    }

    public int getCountryCode() throws JposException {
        return this.m_countryCode;
    }

    public int getDataCount() throws JposException {
        return this.m_dataCount;
    }

    public boolean getDataEventEnabled() throws JposException {
        return this.m_dataEventEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataEventEnabled(boolean bl) throws JposException {
        Object object = this.m_eventLock;
        synchronized (object) {
            this.m_dataEventEnabled = bl;
            this.m_eventLock.notifyAll();
        }
    }

    public String getEPC() throws JposException {
        return this.m_EPC;
    }

    public String getRawData() throws JposException {
        return this.m_rawData;
    }

    public String getSerialNumber() throws JposException {
        return this.m_serialNumber;
    }

    public String getTransitNumber() throws JposException {
        return this.m_transitNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPowerNotify() throws JposException {
        int[] nArray = this.m_powerNotifyEnabled;
        synchronized (this.m_powerNotifyEnabled) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.m_powerNotifyEnabled[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPowerNotify(int n) throws JposException {
        if (this.m_enabled) {
            throw new JposException(106, "This request is illegal because the deviceEnabled is true.");
        }
        if (0 != n && 1 != n) {
            throw new JposException(106, "This request is illegal because the powerNotify parameter is unsupported.");
        }
        int[] nArray = this.m_powerNotifyEnabled;
        synchronized (this.m_powerNotifyEnabled) {
            this.m_powerNotifyEnabled[0] = n;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPowerState() throws JposException {
        int[] nArray = this.m_powerState;
        synchronized (this.m_powerState) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.m_powerState[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPowerState(int n) {
        int[] nArray = this.m_powerState;
        synchronized (this.m_powerState) {
            this.m_powerState[0] = n;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void beginInsertion(int n) throws JposException {
        boolean bl = false;
        this.verifyClaimedState();
        this.verifyEnabledState();
        this.updateStatus();
        if (2 != this.getState()) {
            throw new JposException(113, "This request is illegal because the service is busy.");
        }
        if (-1 > n) {
            throw new JposException(106, "This request is illegal. An invalid timeout parameter was specified.");
        }
        if (-1 == n) {
            bl = true;
        }
        while (0 < n || bl) {
            long l = System.currentTimeMillis();
            if (this.m_slipPaperPresent) {
                return;
            }
            long l2 = System.currentTimeMillis() - l;
            if (l2 > (long)n) {
                n = 0;
                continue;
            }
            n = (int)((long)n - l2);
        }
        if (this.m_slipPaperPresent) {
            return;
        }
        throw new JposException(112, "The beginInsertion operation timed out because a check is not inserted.");
    }

    public void beginRemoval(int n) throws JposException {
        boolean bl = false;
        this.verifyClaimedState();
        this.verifyEnabledState();
        if (2 != this.getState()) {
            throw new JposException(113, "This request is illegal because the service is busy.");
        }
        if (-1 > n) {
            throw new JposException(106, "This beginRemoval operation is illegal. An invalid timeout parameter was specified.");
        }
        this.requestEjectMicr();
        if (-1 == n) {
            bl = true;
        }
        this.updateStatus();
        while (0 < n || bl) {
            this.updateStatus();
            long l = System.currentTimeMillis();
            if (!this.m_slipPaperPresent) {
                return;
            }
            long l2 = System.currentTimeMillis() - l;
            if (l2 > (long)n) {
                n = 0;
                continue;
            }
            n = (int)((long)n - l2);
        }
        if (!this.m_slipPaperPresent) {
            return;
        }
        throw new JposException(112, "The beginRemoval operation timed out because a check is not removed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearInput() throws JposException {
        this.verifyClaimedState();
        Object object = this.m_eventLock;
        synchronized (object) {
            this.m_eventQueue.clear();
            this.m_dataCount = 0;
        }
    }

    public void endInsertion() throws JposException {
        this.verifyClaimedState();
        this.verifyEnabledState();
        if (2 != this.getState()) {
            throw new JposException(113, "This request is illegal because the service is busy.");
        }
        if (!this.m_slipPaperPresent) {
            throw new JposException(114, 201, "This endInsertion operation failed because a check is not detected.");
        }
        this.requestScanMicr();
    }

    public void endRemoval() throws JposException {
        this.verifyClaimedState();
        this.verifyEnabledState();
        if (2 != this.getState()) {
            throw new JposException(113, "This request is illegal because the service is busy.");
        }
        this.requestEndRemoval();
        if (this.m_slipPaperPresent) {
            throw new JposException(114, 202, "This endRemoval operation failed because a check is detected.");
        }
    }

    public void resetStatistics(String string) throws JposException {
        this.verifyClaimedState();
        this.verifyEnabledState();
        throw new JposException(106, "This request failed because this function is not supported.");
    }

    public void retrieveStatistics(String[] stringArray) throws JposException {
        this.verifyClaimedState();
        this.verifyEnabledState();
        throw new JposException(106, "This request failed because this function is not supported.");
    }

    public void updateStatistics(String string) throws JposException {
        this.verifyClaimedState();
        this.verifyEnabledState();
        throw new JposException(106, "This request failed because this function is not supported.");
    }

    public void compareFirmwareVersion(String string, int[] nArray) throws JposException {
        this.verifyClaimedState();
        this.verifyEnabledState();
        throw new JposException(106, "This request failed because this function is not supported.");
    }

    public void updateFirmware(String string) throws JposException {
        this.verifyClaimedState();
        this.verifyEnabledState();
        throw new JposException(106, "This request failed because this function is not supported.");
    }

    public void clearInputProperties() throws JposException {
        this.m_checkHealthText = "";
        this.setFreezeEvents(false);
        this.setAutoDisable(false);
        this.m_accountNumber = "";
        this.m_amount = "";
        this.m_bankNumber = "";
        this.m_checkType = 0;
        this.m_countryCode = 0;
        this.m_dataCount = 0;
        this.m_EPC = "";
        this.m_rawData = "";
        this.m_serialNumber = "";
        this.m_transitNumber = "";
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.button)) {
            String string = "";
            String string2 = "";
            try {
                this.verifyEnabledState();
                this.m_checkHealthText = "Doing checkHealth...\n";
                this.setDataEventEnabled(true);
                this.updateStatus();
                if (!this.m_slipPaperPresent) {
                    this.m_checkHealthText = this.m_checkHealthText + "  failure";
                    throw new JposException(114, 201, "CheckHealth failed because a check is not detected.\n                    Please insert a check.");
                }
                if (!this.requestScanMicr()) {
                    this.beginRemoval(-1);
                    this.endRemoval();
                    throw new JposException(114, 204, "CheckHealth failed because the entire input data stream was unreadable.\n                    No data is available.");
                }
                string2 = this.getRawData();
                this.m_checkHealthText = this.m_checkHealthText + "  RawData\t= " + this.getRawData() + "\n";
                this.m_checkHealthText = this.m_checkHealthText + "  AccountNumber\t= " + this.getAccountNumber() + "\n";
                this.m_checkHealthText = this.m_checkHealthText + "  BankNumber\t= " + this.getBankNumber() + "\n";
                this.m_checkHealthText = this.m_checkHealthText + "  SerialNumber\t= " + this.getSerialNumber() + "\n";
                this.m_checkHealthText = this.m_checkHealthText + "  TransitNumber\t= " + this.getTransitNumber() + "\n";
                switch (this.getCheckType()) {
                    case 1: {
                        string = "MICR_CT_PERSONAL";
                        break;
                    }
                    case 2: {
                        string = "MICR_CT_BUSINESS";
                        break;
                    }
                    case 99: {
                        string = "MICR_CT_UNKNOWN";
                        break;
                    }
                    default: {
                        string = "MICR_CT_UNKNOWN";
                    }
                }
                this.m_checkHealthText = this.m_checkHealthText + "  CheckType\t= " + string + "\n";
                switch (this.getCountryCode()) {
                    case 1: {
                        string = "MICR_CC_USA";
                        break;
                    }
                    case 2: {
                        string = "MICR_CC_CANADA";
                        break;
                    }
                    case 3: {
                        string = "MICR_CC_MEXICO";
                        break;
                    }
                    case 99: {
                        string = "MICR_CC_UNKNOWN";
                        break;
                    }
                    default: {
                        string = "MICR_CC_UNKNOWN";
                    }
                }
                this.m_checkHealthText = this.m_checkHealthText + "  CountryCode\t= " + string + "\n";
                this.beginRemoval(-1);
                this.endRemoval();
            }
            catch (JposException jposException) {
                this.m_checkHealthText = jposException.getMessage();
                block12 : switch (jposException.getErrorCode()) {
                    case 0: {
                        this.textField.setText("JPOS_SUCCESS");
                        break;
                    }
                    case 101: {
                        this.textField.setText("JPOS_E_CLOSED");
                        break;
                    }
                    case 102: {
                        this.textField.setText("JPOS_E_CLAIMED");
                        break;
                    }
                    case 103: {
                        this.textField.setText("JPOS_E_NOTCLAIMED");
                        break;
                    }
                    case 104: {
                        this.textField.setText("JPOS_E_NOSERVICE");
                        break;
                    }
                    case 105: {
                        this.textField.setText("JPOS_E_DISABLED");
                        break;
                    }
                    case 106: {
                        this.textField.setText("JPOS_E_ILLEGAL");
                        break;
                    }
                    case 107: {
                        this.textField.setText("JPOS_E_NOHARDWARE");
                        break;
                    }
                    case 108: {
                        this.textField.setText("JPOS_E_OFFLINE");
                        break;
                    }
                    case 109: {
                        this.textField.setText("JPOS_E_NOEXIST");
                        break;
                    }
                    case 110: {
                        this.textField.setText("JPOS_E_EXISTS");
                        break;
                    }
                    case 111: {
                        this.textField.setText("JPOS_E_FAILURE");
                        break;
                    }
                    case 112: {
                        this.textField.setText("JPOS_E_TIMEOUT");
                        break;
                    }
                    case 113: {
                        this.textField.setText("JPOS_E_BUSY");
                        break;
                    }
                    case 114: {
                        switch (jposException.getErrorCodeExtended()) {
                            case 201: {
                                this.textField.setText("JPOS_EMICR_NOCHECK");
                                break block12;
                            }
                            case 202: {
                                this.textField.setText("JPOS_EMICR_CHECK");
                                break block12;
                            }
                            case 203: {
                                this.textField.setText("JPOS_EMICR_BADDATA");
                                break block12;
                            }
                            case 204: {
                                this.textField.setText("JPOS_EMICR_NODATA");
                                break block12;
                            }
                            case 205: {
                                this.textField.setText("JPOS_EMICR_BADSIZE");
                                break block12;
                            }
                            case 206: {
                                this.textField.setText("JPOS_EMICR_JAM");
                                break block12;
                            }
                            case 207: {
                                this.textField.setText("JPOS_EMICR_CHECKDIGIT");
                                break block12;
                            }
                            case 208: {
                                this.textField.setText("JPOS_EMICR_COVEROPEN");
                                break block12;
                            }
                        }
                        this.textField.setText("ResultCode Error !?");
                        break;
                    }
                    default: {
                        this.textField.setText("ResultCode Error !?");
                    }
                }
                return;
            }
            this.m_checkHealthText = this.m_checkHealthText + "success!\n";
            this.textField.setText(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEvent(JposEvent jposEvent) {
        Object object = this.m_eventLock;
        synchronized (object) {
            this.m_eventQueue.add(jposEvent);
            this.m_eventLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStatus() throws JposException {
        StarIOPort starIOPort = this.m_port;
        synchronized (starIOPort) {
            StarPrinterStatus starPrinterStatus;
            try {
                starPrinterStatus = this.m_port.retreiveStatus();
            }
            catch (StarIOPortException starIOPortException) {
                if (1 == this.getPowerNotify() && this.getPowerState() != 2002) {
                    this.setPowerState(2002);
                    this.addEvent((JposEvent)new StatusUpdateEvent((Object)this, 2002));
                }
                throw new JposException(107, "this print operation failed because device communication failed.");
            }
            if (1 == this.getPowerNotify() && starPrinterStatus.offline && 2002 == this.getPowerState()) {
                this.setPowerState(2003);
                this.addEvent((JposEvent)new StatusUpdateEvent((Object)this, 2003));
            }
            try {
                if (1 == this.getPowerNotify()) {
                    if (starPrinterStatus.offline) {
                        if (2003 != this.getPowerState()) {
                            this.setPowerState(2003);
                            this.addEvent((JposEvent)new StatusUpdateEvent((Object)this, 2003));
                        }
                    } else if (2001 != this.getPowerState()) {
                        this.setPowerState(2001);
                        this.addEvent((JposEvent)new StatusUpdateEvent((Object)this, 2001));
                    }
                }
                StarPrinterStatus[] starPrinterStatusArray = this.m_cachedStatus;
                synchronized (this.m_cachedStatus) {
                    StarPrinterStatus starPrinterStatus2 = this.m_cachedStatus[0];
                    this.m_cachedStatus[0] = starPrinterStatus;
                    this.m_cachedStatus.notifyAll();
                    if (starPrinterStatus2.rawLength >= 9) {
                        this.m_slipPaperPresent = 96 != (starPrinterStatus2.raw[6] & 0x60);
                    }
                    // ** MonitorExit[var4_5] (shouldn't be in output)
                    Object var7_7 = null;
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (this.getPowerNotify() == 1 && !starPrinterStatus.offline && this.getPowerState() != 2001) {
                    this.setPowerState(2001);
                    this.addEvent((JposEvent)new StatusUpdateEvent((Object)this, 2001));
                }
                throw throwable;
            }
            {
                if (this.getPowerNotify() == 1 && !starPrinterStatus.offline && this.getPowerState() != 2001) {
                    this.setPowerState(2001);
                    this.addEvent((JposEvent)new StatusUpdateEvent((Object)this, 2001));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyClaimedState() throws JposException {
        boolean[] blArray = this.m_claimLock;
        synchronized (this.m_claimLock) {
            if (!this.m_claimLock[0]) {
                throw new JposException(103, "This service is not claimed.");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void verifyEnabledState() throws JposException {
        if (!this.m_enabled) {
            throw new JposException(105, "The service is not enabled.");
        }
    }

    private boolean requestScanMicr() throws JposException {
        String string = "";
        StarIOPort starIOPort = this.m_port;
        synchronized (starIOPort) {
            this.updateStatus();
            if (2003 == this.getPowerState()) {
                throw new JposException(108, "This print operation failed because the device is offline.");
            }
            if (2002 == this.getPowerState()) {
                throw new JposException(107, "This print operation failed because the device is off.");
            }
            byte[] byArray = new byte[]{27, 43, 65, 51, 27, 28, 77, 49, true == this.m_format.equals("CMC7") ? (byte)49 : 48};
            OutputDataSet outputDataSet = new OutputDataSet();
            outputDataSet.addOutputData(byArray);
            this.updateStatus();
            try {
                int n;
                int n2;
                for (n2 = 0; n2 < outputDataSet.getSize(); ++n2) {
                    int n3;
                    byte[] byArray2 = outputDataSet.getOutputData(n2);
                    long l = System.currentTimeMillis();
                    for (n = 0; System.currentTimeMillis() - l < (long)this.m_ioProgressTimeout && n < byArray2.length; n += n3) {
                        n3 = this.m_port.writePort(byArray2, n, byArray2.length - n);
                        if (0 == n3) continue;
                        l = System.currentTimeMillis();
                    }
                    if (n >= byArray2.length) continue;
                    this.updateStatus();
                    throw new JposException(112);
                }
                this.READSTATE = 0;
                int n4 = 0;
                boolean bl = true;
                boolean bl2 = false;
                n = 0;
                byte[] byArray3 = new byte[100];
                int n5 = 0;
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                n2 = this.m_port.readPort(byArray3, 0, 99);
                if (0 == n2) {
                    bl = false;
                    bl2 = false;
                }
                while (bl) {
                    byte by = byArray3[n5];
                    if (this.READSTATE == 0) {
                        if (27 == by) {
                            this.READSTATE = 3;
                        } else {
                            this.READSTATE = 2;
                            switch (by) {
                                case 15: {
                                    n4 = 6;
                                    break;
                                }
                                case 33: {
                                    n4 = 7;
                                    break;
                                }
                                case 35: {
                                    n4 = 8;
                                    break;
                                }
                                case 37: {
                                    n4 = 9;
                                    break;
                                }
                                case 39: {
                                    n4 = 10;
                                    break;
                                }
                                case 41: {
                                    n4 = 11;
                                    break;
                                }
                                case 43: {
                                    n4 = 12;
                                    break;
                                }
                                case 45: {
                                    n4 = 13;
                                    break;
                                }
                                case 47: {
                                    n4 = 14;
                                    break;
                                }
                                default: {
                                    this.READSTATE = 0;
                                    break;
                                }
                            }
                        }
                    } else if (this.READSTATE == 2) {
                        if (0 == --n4) {
                            this.READSTATE = 0;
                        }
                    } else if (this.READSTATE == 3) {
                        if (44 == by) {
                            this.READSTATE = 1;
                        }
                    } else if (this.READSTATE == 1) {
                        if (10 == by) {
                            n = 1;
                        } else if (0 == by && 1 == n) {
                            this.READSTATE = 0;
                            bl = false;
                            bl2 = "" != string;
                        } else if (0 == by && 0 == n) {
                            this.READSTATE = 0;
                            bl = false;
                            bl2 = false;
                        } else if (this.m_format.equals("CMC7")) {
                            switch (by) {
                                case 32: 
                                case 35: 
                                case 47: 
                                case 48: 
                                case 49: 
                                case 50: 
                                case 51: 
                                case 52: 
                                case 53: 
                                case 54: 
                                case 55: 
                                case 56: 
                                case 57: 
                                case 61: 
                                case 62: 
                                case 94: {
                                    string = string + (char)by;
                                    break;
                                }
                                default: {
                                    this.READSTATE = 0;
                                    bl = false;
                                    bl2 = false;
                                    break;
                                }
                            }
                        } else {
                            switch (by) {
                                case 32: 
                                case 48: 
                                case 49: 
                                case 50: 
                                case 51: 
                                case 52: 
                                case 53: 
                                case 54: 
                                case 55: 
                                case 56: 
                                case 57: {
                                    string = string + (char)by;
                                    break;
                                }
                                case 84: {
                                    string = string + 't';
                                    break;
                                }
                                case 65: {
                                    string = string + 'a';
                                    break;
                                }
                                case 79: {
                                    string = string + 'o';
                                    break;
                                }
                                case 68: {
                                    string = string + '-';
                                    break;
                                }
                                default: {
                                    this.READSTATE = 0;
                                    bl = false;
                                    bl2 = false;
                                    break;
                                }
                            }
                        }
                    } else {
                        this.READSTATE = 0;
                        bl = false;
                        bl2 = false;
                    }
                    ++n5;
                }
                if (bl2) {
                    this.m_rawData = string;
                    this.getParsedRawData();
                    this.addEvent((JposEvent)new DataEvent((Object)this, 0));
                    return true;
                }
                this.m_rawData = "";
                WaitableErrorEvent waitableErrorEvent = new WaitableErrorEvent(this, 114, 204, 2, 12);
                this.addEvent((JposEvent)waitableErrorEvent);
                ++this.m_dataCount;
                return false;
            }
            catch (StarIOPortException starIOPortException) {
                this.updateStatus();
                throw new JposException(112, "StarIOPort Error");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestEjectMicr() throws JposException {
        StarIOPort starIOPort = this.m_port;
        synchronized (starIOPort) {
            try {
                byte[] byArray = new byte[]{27, 43, 65, 51, 27, 12, 50};
                OutputDataSet outputDataSet = new OutputDataSet();
                outputDataSet.addOutputData(byArray);
                this.m_port.beginCheckedBlock();
                for (int i = 0; i < outputDataSet.getSize(); ++i) {
                    int n;
                    int n2;
                    byte[] byArray2 = outputDataSet.getOutputData(i);
                    long l = System.currentTimeMillis();
                    for (n = 0; System.currentTimeMillis() - l < (long)this.m_ioProgressTimeout && n < byArray2.length; n += n2) {
                        n2 = this.m_port.writePort(byArray2, n, byArray2.length - n);
                        if (0 == n2) continue;
                        l = System.currentTimeMillis();
                    }
                    if (n >= byArray2.length) continue;
                    this.updateStatus();
                    throw new JposException(112);
                }
            }
            catch (StarIOPortException starIOPortException) {
                this.updateStatus();
                throw new JposException(112, "StarIOPort Error");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestEndRemoval() throws JposException {
        StarIOPort starIOPort = this.m_port;
        synchronized (starIOPort) {
            try {
                byte[] byArray = new byte[]{27, 43, 65, 48};
                OutputDataSet outputDataSet = new OutputDataSet();
                outputDataSet.addOutputData(byArray);
                this.m_port.beginCheckedBlock();
                for (int i = 0; i < outputDataSet.getSize(); ++i) {
                    int n;
                    int n2;
                    byte[] byArray2 = outputDataSet.getOutputData(i);
                    long l = System.currentTimeMillis();
                    for (n = 0; System.currentTimeMillis() - l < (long)this.m_ioProgressTimeout && n < byArray2.length; n += n2) {
                        n2 = this.m_port.writePort(byArray2, n, byArray2.length - n);
                        if (n2 == 0) continue;
                        l = System.currentTimeMillis();
                    }
                    if (n >= byArray2.length) continue;
                    this.updateStatus();
                    throw new JposException(112);
                }
            }
            catch (StarIOPortException starIOPortException) {
                this.updateStatus();
                throw new JposException(112, "StarIOPort Error");
            }
        }
    }

    private void getParsedRawData() throws JposException {
        block26: {
            int n;
            block30: {
                block29: {
                    block27: {
                        block28: {
                            this.m_serialNumber = "";
                            this.m_transitNumber = "";
                            this.m_bankNumber = "";
                            this.m_accountNumber = "";
                            this.m_countryCode = 99;
                            if (this.m_rawData.charAt(0) != 'o') break block27;
                            this.m_checkType = 2;
                            for (n = 1; n < this.m_rawData.length(); ++n) {
                                if (this.m_rawData.charAt(n) >= '0' && this.m_rawData.charAt(n) <= '9') {
                                    this.m_serialNumber = this.m_serialNumber + this.m_rawData.charAt(n);
                                    continue;
                                }
                                if (this.m_rawData.charAt(n) != '-') break;
                            }
                            if (n != this.m_rawData.length()) break block28;
                            this.m_serialNumber = "";
                            break block29;
                        }
                        if (this.m_rawData.charAt(n) == 'o') break block29;
                        this.m_serialNumber = "";
                        break block29;
                    }
                    this.m_checkType = 1;
                    for (n = this.m_rawData.length(); n > 0; --n) {
                        if (this.m_rawData.charAt(n - 1) >= '0' && this.m_rawData.charAt(n - 1) <= '9') {
                            this.m_serialNumber = this.m_rawData.charAt(n - 1) + this.m_serialNumber;
                            continue;
                        }
                        if (this.m_rawData.charAt(n - 1) != '-') break;
                    }
                }
                for (n = 0; n < this.m_rawData.length(); ++n) {
                    if (this.m_rawData.charAt(n) != 't') continue;
                    ++n;
                    while (n < this.m_rawData.length()) {
                        if (this.m_rawData.charAt(n) >= '0' && this.m_rawData.charAt(n) <= '9') {
                            this.m_transitNumber = this.m_transitNumber + this.m_rawData.charAt(n);
                        } else if (this.m_rawData.charAt(n) != '-') break;
                        ++n;
                    }
                    if (n == this.m_rawData.length()) {
                        this.m_transitNumber = "";
                        break;
                    }
                    if (this.m_rawData.charAt(n) == 't') break;
                    this.m_transitNumber = "";
                    break;
                }
                if (9 == this.m_transitNumber.length()) {
                    this.m_bankNumber = this.m_transitNumber.substring(3, 8);
                } else {
                    this.m_transitNumber = "";
                }
                if (0 >= this.m_serialNumber.length()) break block30;
                ++n;
                while (n < this.m_rawData.length()) {
                    if (this.m_rawData.charAt(n) >= '0' && this.m_rawData.charAt(n) <= '9') {
                        this.m_accountNumber = this.m_accountNumber + this.m_rawData.charAt(n);
                        break;
                    }
                    ++n;
                }
                if (0 >= this.m_accountNumber.length()) break block26;
                ++n;
                while (n < this.m_rawData.length()) {
                    if (this.m_rawData.charAt(n) >= '0' && this.m_rawData.charAt(n) <= '9') {
                        this.m_accountNumber = this.m_accountNumber + this.m_rawData.charAt(n);
                    } else if (this.m_rawData.charAt(n) != '-') break block26;
                    ++n;
                }
                break block26;
            }
            ++n;
            while (n < this.m_rawData.length()) {
                if (this.m_rawData.charAt(n) >= '0' && this.m_rawData.charAt(n) <= '9') {
                    this.m_serialNumber = this.m_serialNumber + this.m_rawData.charAt(n);
                    break;
                }
                ++n;
            }
            if (0 < this.m_serialNumber.length()) {
                ++n;
                while (n < this.m_rawData.length()) {
                    if (this.m_rawData.charAt(n) >= '0' && this.m_rawData.charAt(n) <= '9') {
                        if (this.m_serialNumber.length() < 4) {
                            this.m_serialNumber = this.m_serialNumber + this.m_rawData.charAt(n);
                        } else {
                            this.m_accountNumber = this.m_accountNumber + this.m_rawData.charAt(n);
                        }
                    } else if (this.m_rawData.charAt(n) != '-') break;
                    ++n;
                }
            }
        }
    }

    private class WaitableErrorEvent
    extends ErrorEvent {
        private boolean errorResponseSet;

        public WaitableErrorEvent(Object object, int n, int n2, int n3, int n4) {
            super(object, n, n2, n3, n4);
            this.errorResponseSet = false;
        }

        public synchronized void setErrorResponse(int n) {
            if (11 != n && 12 != n) {
                n = 12;
            }
            this.errorResponse = n;
            this.errorResponseSet = true;
            ((Object)((Object)this)).notifyAll();
        }

        public synchronized int getErrorResponse() {
            while (!this.errorResponseSet) {
                try {
                    ((Object)((Object)this)).wait();
                }
                catch (InterruptedException interruptedException) {
                    this.errorResponse = 12;
                    this.errorResponseSet = true;
                }
            }
            return this.errorResponse;
        }
    }

    private class StatusServer
    implements Runnable {
        private StatusServer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                Object object = MICRStarService.this.m_statusLock;
                synchronized (object) {
                    if (!MICRStarService.this.m_statusThreadLife) {
                        break;
                    }
                }
                try {
                    MICRStarService.this.updateStatus();
                }
                catch (JposException jposException) {
                    // empty catch block
                }
                object = MICRStarService.this.m_statusLock;
                synchronized (object) {
                    try {
                        MICRStarService.this.m_statusLock.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private class EventServer
    implements Runnable {
        private EventServer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            JposEvent jposEvent = null;
            while (true) {
                Object object = MICRStarService.this.m_eventLock;
                synchronized (object) {
                    int n;
                    while (true) {
                        int n2;
                        int n3;
                        boolean bl;
                        n = 0;
                        try {
                            bl = MICRStarService.this.getDataEventEnabled();
                        }
                        catch (JposException jposException) {
                            return;
                        }
                        if (!MICRStarService.this.m_eventThreadLife) {
                            return;
                        }
                        if (MICRStarService.this.m_freezeEvents || MICRStarService.this.m_eventQueue.isEmpty()) {
                            n3 = 0;
                            for (n2 = 0; n2 < MICRStarService.this.m_eventQueue.size(); ++n2) {
                                if (!(MICRStarService.this.m_eventQueue.elementAt(n2) instanceof DataEvent)) continue;
                                ++n3;
                            }
                            MICRStarService.this.m_dataCount = n3;
                        } else {
                            if (bl) break;
                            boolean bl2 = false;
                            n3 = 0;
                            for (n2 = 0; n2 < MICRStarService.this.m_eventQueue.size(); ++n2) {
                                if (MICRStarService.this.m_eventQueue.elementAt(n2) instanceof DataEvent) {
                                    ++n3;
                                    continue;
                                }
                                if (MICRStarService.this.m_eventQueue.elementAt(n2) instanceof ErrorEvent) continue;
                                n = n2;
                                bl2 = true;
                            }
                            MICRStarService.this.m_dataCount = n3;
                            if (bl2) break;
                        }
                        try {
                            MICRStarService.this.m_eventLock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            return;
                        }
                    }
                    if (MICRStarService.this.m_eventQueue.elementAt(n) instanceof DataEvent && 0 < MICRStarService.this.m_dataCount) {
                        MICRStarService.this.m_dataCount--;
                    }
                    jposEvent = (JposEvent)MICRStarService.this.m_eventQueue.remove(n);
                }
                if (null == jposEvent) {
                    return;
                }
                if (jposEvent instanceof StatusUpdateEvent) {
                    MICRStarService.this.m_eventCallbacks.fireStatusUpdateEvent((StatusUpdateEvent)jposEvent);
                    continue;
                }
                if (jposEvent instanceof OutputCompleteEvent) {
                    MICRStarService.this.m_eventCallbacks.fireOutputCompleteEvent((OutputCompleteEvent)jposEvent);
                    continue;
                }
                if (jposEvent instanceof DataEvent) {
                    try {
                        MICRStarService.this.setDataEventEnabled(false);
                    }
                    catch (JposException jposException) {
                        // empty catch block
                    }
                    MICRStarService.this.m_eventCallbacks.fireDataEvent((DataEvent)jposEvent);
                    continue;
                }
                if (jposEvent instanceof ErrorEvent) {
                    MICRStarService.this.m_eventCallbacks.fireErrorEvent((ErrorEvent)jposEvent);
                    continue;
                }
                if (!(jposEvent instanceof DirectIOEvent)) continue;
                MICRStarService.this.m_eventCallbacks.fireDirectIOEvent((DirectIOEvent)jposEvent);
            }
        }
    }
}

