/*
 * Decompiled with CFR 0.152.
 */
package com.starmicronics.commandemulator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class CommandEmulator {
    public static final String TYPE_BINARY_CONFIGURATION_SET = "BinaryConfigurationSet";
    public static final String TYPE_XML_CONFIGURATION_SET = "XMLConfigurationSet";
    public static final String DEFAULT_CONFIG = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\" ?><configuration>  <CommandEmulator>    <setting name=\"Source Emulator Plugin Path\" type=\"string\">StarLineModeSE</setting>    <setting name=\"Target Converter Plugin Path\" type=\"string\">StarTSPTC</setting>  </CommandEmulator>  <StarLineModeSE>    <Defaults>      <setting name=\"Max Printable Width\" type=\"string\">72mm</setting>    </Defaults>  </StarLineModeSE>  <StarTSPTC>    <setting name=\"Model\" type=\"string\">TSP100</setting>    <setting name=\"Paper Width\" type=\"string\">76mm</setting>  </StarTSPTC></configuration>";
    private long m_commandEmulator;
    private static boolean s_classServicesReadied;
    private static final String s_pluginDirPath;

    public CommandEmulator(String string, byte[] byArray) throws Exception {
        if (!s_classServicesReadied) {
            throw new Exception("The required native libraries  & class services are not available.");
        }
        if (string == null || byArray == null) {
            throw new NullPointerException("The 'configDataType' and 'configData' parameters must not be null");
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                CommandEmulator.this.dispose();
            }
        });
        this.m_commandEmulator = CommandEmulator.native_CommandEmulator_create(string.getBytes(), byArray, s_pluginDirPath.getBytes());
    }

    public CommandEmulator(String string) throws Exception {
        if (!s_classServicesReadied) {
            throw new Exception("The required native libraries & class services are not available.");
        }
        if (string == null) {
            throw new NullPointerException("The 'filePath' parameter must not be null");
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                CommandEmulator.this.dispose();
            }
        });
        this.m_commandEmulator = CommandEmulator.native_CommandEmulator_create(string.getBytes(), s_pluginDirPath.getBytes());
    }

    public byte[] emulate(byte[] byArray, int n) throws Exception {
        if (this.m_commandEmulator == 0L) {
            throw new Exception("This instance has already been disposed");
        }
        if (byArray == null) {
            throw new NullPointerException("The 'data' parameter must not be null");
        }
        return CommandEmulator.native_CommandEmulator_emulate(this.m_commandEmulator, byArray, n);
    }

    public void dispose() {
        if (this.m_commandEmulator != 0L) {
            CommandEmulator.native_CommandEmulator_destroy(this.m_commandEmulator);
            this.m_commandEmulator = 0L;
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    private static final native long native_CommandEmulator_create(byte[] var0, byte[] var1) throws UnsatisfiedLinkError, UnknownError, Exception;

    private static final native long native_CommandEmulator_create(byte[] var0, byte[] var1, byte[] var2) throws UnsatisfiedLinkError, UnknownError, Exception;

    private static final native byte[] native_CommandEmulator_emulate(long var0, byte[] var2, int var3) throws UnknownError, Exception;

    private static final native void native_CommandEmulator_destroy(long var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final boolean isInstalledResourceBinarySame(String string, String string2) {
        InputStream inputStream = null;
        InputStream inputStream2 = null;
        try {
            inputStream = new FileInputStream(new File(string));
            byte[] byArray = new byte[10240];
            inputStream2 = CommandEmulator.class.getClassLoader().getResource(string2).openStream();
            byte[] byArray2 = new byte[10240];
            block32: while (true) {
                int n;
                int n2;
                if ((n2 = inputStream.read(byArray)) <= 0) {
                    if (inputStream2.read(byArray2) > 0) {
                        n = 0;
                        return n != 0;
                    }
                    n = 1;
                    return n != 0;
                }
                n = 0;
                while (true) {
                    int n3;
                    if (n2 <= 0) continue block32;
                    int n4 = inputStream2.read(byArray2, 0, n2);
                    if (n4 <= 0) {
                        n3 = 0;
                        return n3 != 0;
                    }
                    n2 -= n4;
                    for (n3 = 0; n3 < n4; ++n3) {
                        if (byArray[n + n3] == byArray2[n3]) continue;
                        boolean bl = false;
                        return bl;
                    }
                    n += n4;
                }
                break;
            }
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (inputStream2 != null) {
                    inputStream2.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void installResource(String string, String string2) throws Exception {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            int n;
            inputStream = CommandEmulator.class.getClassLoader().getResource(string2).openStream();
            File file = new File(string);
            String string3 = file.getParent();
            if (string3 != null) {
                new File(string3).mkdirs();
            }
            file.delete();
            file.createNewFile();
            outputStream = new FileOutputStream(file);
            byte[] byArray = new byte[10240];
            while ((n = inputStream.read(byArray)) > 0) {
                outputStream.write(byArray, 0, n);
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 1 && stringArray[0].equals("-version")) {
            System.out.println("CommandEmulator: version 20061106");
            return;
        }
        try {
            int n;
            CommandEmulator commandEmulator = stringArray.length == 1 ? new CommandEmulator(stringArray[0]) : new CommandEmulator(TYPE_XML_CONFIGURATION_SET, DEFAULT_CONFIG.getBytes());
            byte[] byArray = new byte[1024];
            while ((n = System.in.read(byArray)) != -1) {
                byte[] byArray2 = commandEmulator.emulate(byArray, n);
                if (byArray2 == null) continue;
                System.out.write(byArray2);
            }
        }
        catch (Exception exception) {
            System.err.println("CommandEmulator: failure");
            exception.printStackTrace();
        }
    }

    static {
        try {
            String string = System.getProperty("user.home") + "/.commandemulator/";
            String string2 = System.getProperty("os.name");
            String[] stringArray = string2.indexOf("Windows") >= 0 ? new String[]{"xerces-c_2_7", "Configuration", "CommandEmulator", "TargetAction", "GenericAction", "StarLineModeSE", "StarTSPTC", "CropGAF", "MergeGAF", "WallMountGAF", "CmdSubPP", "AddImageGAF"} : new String[]{"Configuration", "CommandEmulator", "TargetAction", "GenericAction", "StarLineModeSE", "StarTSPTC", "CropGAF", "MergeGAF", "WallMountGAF", "CmdSubPP", "AddImageGAF"};
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = System.mapLibraryName(stringArray[i]);
                if (!CommandEmulator.isInstalledResourceBinarySame(string + string3, "com/starmicronics/commandemulator/resources/" + string3)) {
                    CommandEmulator.installResource(string + string3, "com/starmicronics/commandemulator/resources/" + string3);
                }
                if (string2.indexOf("Windows") < 0) continue;
                Runtime.getRuntime().load(string + string3);
            }
            String[] stringArray2 = new String[]{"CommandEmulatorJ"};
            for (int i = 0; i < stringArray2.length; ++i) {
                String string4 = System.mapLibraryName(stringArray2[i]);
                if (!CommandEmulator.isInstalledResourceBinarySame(string + string4, "com/starmicronics/commandemulator/resources/" + string4)) {
                    CommandEmulator.installResource(string + string4, "com/starmicronics/commandemulator/resources/" + string4);
                }
                Runtime.getRuntime().load(string + string4);
            }
            s_classServicesReadied = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            s_classServicesReadied = false;
        }
        s_pluginDirPath = System.getProperty("user.home") + "/.commandemulator/";
    }
}

